<?php
session_start();
require_once "../config/db.php";
require_once "../config/security.php";

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit;
}

// فحص ID
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("❌ معرف الطالب غير صالح.");
}

$student_id = (int) $_GET['id'];

// جلب بيانات الطالب
$stmt = $conn->prepare("SELECT * FROM students WHERE id=? LIMIT 1");
$stmt->execute([$student_id]);
$student = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$student) {
    die("❌ الطالب غير موجود.");
}

try {

    $conn->beginTransaction();

    /* ================ 1) تحديث حالة الطالب ================ */
    $conn->prepare("UPDATE students SET status='accepted' WHERE id=?")
         ->execute([$student_id]);

    /* ================ 2) إنشاء حساب مالي إذا لم يكن موجود ================ */
    $chk = $conn->prepare("SELECT id FROM accounts WHERE student_id=? LIMIT 1");
    $chk->execute([$student_id]);

    if ($chk->rowCount() == 0) {

        // تحديد القسط الكلي
        $total_fee = (int)$student['college_fee'];

        if ($total_fee <= 0) {
            $total_fee = ($student['study_type'] === 'مسائي') ? 2500000 : 1500000;
        }

        // إنشاء الحساب
        $stmtAcc = $conn->prepare("
            INSERT INTO accounts (
                student_id, total_fee, paid, remaining,
                level, payment_plan,
                installment1, installment2, installment3, installment4, installment5, installment6,
                due_date, status, last_overdue, collection_status
            ) VALUES (
                ?, ?, 0, ?,
                'المرحلة الأولى', 'دفعة واحدة',
                0,0,0,0,0,0,
                DATE_ADD(CURDATE(), INTERVAL 30 DAY),
                'normal', 0, 'none'
            )
        ");
        $stmtAcc->execute([$student_id, $total_fee, $total_fee]);

        $account_id = $conn->lastInsertId();

        // إنشاء أول قسط
        $stmtSch = $conn->prepare("
            INSERT INTO installment_schedule (
                account_id, installment_number, amount, due_date,
                paid_amount, status
            ) VALUES (
                ?, 1, ?, DATE_ADD(CURDATE(), INTERVAL 30 DAY),
                0, 'pending'
            )
        ");
        $stmtSch->execute([$account_id, $total_fee]);
    }

    $conn->commit();

    /* ================ 3) الانتقال إلى توليد PDF مباشرة ================ */
    header("Location: generate_form.php?id=".$student_id);
    exit;

} catch (Exception $e) {

    if ($conn->inTransaction()) {
        $conn->rollBack();
    }

    die("❌ حدث خطأ أثناء قبول الطالب: " . $e->getMessage());
}