<?php
session_start();
require_once "../config/db.php";
require_once "../config/app.php";
require_once "../config/security.php";

// حماية الدخول
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit;
}

// جلب الأقسام + القسط
$colleges = $conn->query("
    SELECT college_name, fee 
    FROM colleges 
    ORDER BY college_name ASC
")->fetchAll(PDO::FETCH_ASSOC);

// جلب قنوات التقديم
$channels = $conn->query("
    SELECT channel_name 
    FROM channels 
    ORDER BY id ASC
")->fetchAll(PDO::FETCH_ASSOC);

$success = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {

    // استقبال البيانات
    $full_name      = sanitize($_POST['full_name']);
    $mother_name    = sanitize($_POST['mother_name']);
    $phone          = sanitize($_POST['phone']);
    $email          = sanitize($_POST['email']);
    $national_or_passport = sanitize($_POST['id_number']);
    $birth_place    = sanitize($_POST['birth_place']);
    $address        = sanitize($_POST['address']);
    $nearest_point  = sanitize($_POST['near_point']);
    $gender         = sanitize($_POST['gender']);
    $guardian_phone1 = sanitize($_POST['guardian_phone']);

    // المدرسة
    $school_name    = sanitize($_POST['school_name']);
    $branch         = sanitize($_POST['school_branch']);
    $exam_round     = sanitize($_POST['exam_round']);
    $attempts       = sanitize($_POST['attempt_system']);
    $fail_years     = sanitize($_POST['fails_years']);
    $exam_number    = sanitize($_POST['exam_number']);
    $subjects_count = sanitize($_POST['subjects']);
    $total_score    = sanitize($_POST['total_score']);
    $average        = sanitize($_POST['average']);
    $grad_year      = sanitize($_POST['grad_year']);

    // الكلية
    $college_name   = sanitize($_POST['college_name']);
    $study_type     = sanitize($_POST['study_type']);
    $admission_channel = sanitize($_POST['admission_channel']);
    $college_fee    = intval($_POST['college_fee']);

    // بيانات النظام
    $app_username   = sanitize($_POST['app_username']);
    $app_password   = sanitize($_POST['app_password']);
    $dorm_request   = sanitize($_POST['dorm']);

    // guardian_phone2 غير مستخدم
    $guardian_phone2 = "";

    // صورة الطالب
    $student_photo = "";
    if (!empty($_FILES['photo']['name'])) {
        $student_photo = "student_" . time() . ".jpg";
        move_uploaded_file($_FILES['photo']['tmp_name'], "../uploads/student_photos/" . $student_photo);
    }

    // الجامعة ثابتة
    $university_name = "جامعة النبراس";

    // إضافة الطالب
    $stmt = $conn->prepare("
        INSERT INTO students (
            full_name, national_or_passport, phone, email, mother_name, birth_place, address, nearest_point, gender,
            guardian_phone1, guardian_phone2,
            school_name, branch, exam_round, attempts, fail_years, exam_number, subjects_count, total_score, average,
            admission_channel, university_name, college_name, study_type, college_fee,
            app_username, app_password, dorm_request, status, student_photo, secret_number
        ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)
    ");

    $stmt->execute([
        $full_name, $national_or_passport, $phone, $email, $mother_name, $birth_place, $address, $nearest_point, $gender,
        $guardian_phone1, $guardian_phone2,
        $school_name, $branch, $exam_round, $attempts, $fail_years, $exam_number, $subjects_count, $total_score, $average,
        $admission_channel, $university_name, $college_name, $study_type, $college_fee,
        $app_username, $app_password, $dorm_request, "pending", $student_photo, $grad_year
    ]);

    $success = "✔ تم إضافة الطالب بنجاح!";
}

// عنوان الصفحة
$page_title = "إضافة طالب جديد";
require_once "includes/header.php";
require_once "includes/navbar.php";
?>

<style>
.page-content {
    padding: 25px;
}

/* صندوق زجاجي */
.glass-form {
    max-width: 1150px;
    margin: 20px auto;
    background: rgba(255,255,255,0.07);
    padding: 30px;
    border-radius: 20px;
    border: 1px solid rgba(255,255,255,0.12);
    box-shadow: 0 12px 40px rgba(0,0,0,0.45);
}

/* العناوين */
.section-title {
    font-size: 22px;
    font-weight: 800;
    margin: 20px 0 10px;
    color: #93c5fd;
}

.form-label {
    font-weight: 600;
    color: #dbeafe;
}

.form-control, select {
    background: rgba(255,255,255,0.15);
    border: 1px solid rgba(255,255,255,0.30);
    color: white;
    border-radius: 12px;
}

.form-control:focus, select:focus {
    border-color: #60a5fa;
    box-shadow: 0 0 0 2px #3b82f6;
}

.success-box {
    background: rgba(16,185,129,0.25);
    border: 1px solid rgba(16,185,129,0.45);
    padding: 12px;
    border-radius: 12px;
    text-align: center;
    margin-bottom: 15px;
    color: #bbf7d0;
}

.btn-main {
    background: linear-gradient(90deg,#3b82f6,#6366f1);
    border: 0;
    padding: 12px 20px;
    border-radius: 14px;
    color: white;
    font-weight: 700;
    font-size: 16px;
}
</style>

<div class="page-content">

<div class="glass-form">

    <?php if ($success): ?>
        <div class="success-box"><?= $success ?></div>
    <?php endif; ?>

    <form method="POST" enctype="multipart/form-data">

        <!-- المعلومات الشخصية -->
        <div class="section-title">🧍 المعلومات الشخصية</div>

        <div class="row g-3">

            <div class="col-md-6">
                <label class="form-label">الاسم الرباعي واللقب</label>
                <input type="text" name="full_name" class="form-control" required>
            </div>

            <div class="col-md-6">
                <label class="form-label">اسم الأم الثلاثي</label>
                <input type="text" name="mother_name" class="form-control" required>
            </div>

            <div class="col-md-4">
                <label class="form-label">رقم الهاتف</label>
                <input type="text" name="phone" class="form-control" required>
            </div>

            <div class="col-md-4">
                <label class="form-label">رقم ولي الأمر</label>
                <input type="text" name="guardian_phone" class="form-control">
            </div>

            <div class="col-md-4">
                <label class="form-label">الجنس</label>
                <select name="gender" class="form-control">
                    <option>ذكر</option>
                    <option>أنثى</option>
                </select>
            </div>

            <div class="col-md-4">
                <label class="form-label">البريد الإلكتروني</label>
                <input type="email" name="email" class="form-control">
            </div>

            <div class="col-md-4">
                <label class="form-label">رقم الهوية / الجواز</label>
                <input type="text" name="id_number" class="form-control">
            </div>

            <div class="col-md-4">
                <label class="form-label">محل الولادة</label>
                <input type="text" name="birth_place" class="form-control">
            </div>

            <div class="col-md-6">
                <label class="form-label">العنوان</label>
                <input type="text" name="address" class="form-control">
            </div>

            <div class="col-md-6">
                <label class="form-label">أقرب نقطة دالة</label>
                <input type="text" name="near_point" class="form-control">
            </div>

            <div class="col-md-12">
                <label class="form-label">صورة الطالب</label>
                <input type="file" name="photo" class="form-control">
            </div>

        </div>

        <!-- المدرسة -->
        <div class="section-title">🏫 معلومات المدرسة / المعهد</div>

        <div class="row g-3">

            <div class="col-md-6">
                <label class="form-label">اسم المدرسة</label>
                <input type="text" name="school_name" class="form-control">
            </div>

            <div class="col-md-6">
                <label class="form-label">الفرع</label>
                <input type="text" name="school_branch" class="form-control">
            </div>

            <div class="col-md-4">
                <label class="form-label">الدور</label>
                <select name="exam_round" class="form-control">
                    <option>الدور الاول</option>
                    <option>الدور الثاني</option>
                    <option>الدور الثالث</option>
                </select>
            </div>

            <div class="col-md-4">
                <label class="form-label">نظام المحاولات</label>
                <select name="attempt_system" class="form-control">
                    <option>نعم</option>
                    <option>لا</option>
                </select>
            </div>

            <div class="col-md-4">
                <label class="form-label">عدد سنوات الرسوب</label>
                <input type="text" name="fails_years" class="form-control">
            </div>

            <div class="col-md-3">
                <label class="form-label">الرقم الامتحاني</label>
                <input type="text" name="exam_number" class="form-control" required>
            </div>

            <div class="col-md-3">
                <label class="form-label">عدد الدروس</label>
                <input type="number" name="subjects" id="subjects" class="form-control" onkeyup="calcAvg()">
            </div>

            <div class="col-md-3">
                <label class="form-label">المجموع</label>
                <input type="number" name="total_score" id="total_score" class="form-control" onkeyup="calcAvg()">
            </div>

            <div class="col-md-3">
                <label class="form-label">المعدل</label>
                <input type="text" name="average" id="average" class="form-control">
            </div>

            <script>
            function calcAvg() {
                let s = document.getElementById("subjects").value;
                let t = document.getElementById("total_score").value;
                if (s > 0) document.getElementById("average").value = (t / s).toFixed(2);
            }
            </script>

            <div class="col-md-4">
                <label class="form-label">سنة التخرج</label>
                <input type="text" name="grad_year" class="form-control" placeholder="مثال: 2024">
            </div>

        </div>

        <!-- الكلية -->
        <div class="section-title">🏛️ الكلية / القسم</div>

        <div class="row g-3">

            <div class="col-md-6">
                <label class="form-label">القسم / الكلية</label>
                <select name="college_name" class="form-control" id="collegeSelect" onchange="updateFee()">
                    <?php foreach ($colleges as $c): ?>
                        <option value="<?= htmlspecialchars($c['college_name']) ?>"
                                data-fee="<?= $c['fee'] ?>">
                            <?= htmlspecialchars($c['college_name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="col-md-6">
                <label class="form-label">القسط السنوي</label>
                <input type="number" name="college_fee" id="college_fee" 
                       class="form-control" value="<?= $colleges[0]['fee'] ?>">
            </div>

            <script>
            function updateFee() {
                let select = document.getElementById("collegeSelect");
                let fee = select.options[select.selectedIndex].getAttribute("data-fee");
                document.getElementById("college_fee").value = fee;
            }
            </script>

            <div class="col-md-6">
                <label class="form-label">نوع الدراسة</label>
                <select name="study_type" class="form-control">
                    <option>صباحي</option>
                    <option>مسائي</option>
                </select>
            </div>

            <div class="col-md-6">
                <label class="form-label">قناة التقديم</label>
                <select name="admission_channel" class="form-control">
                    <?php foreach ($channels as $ch): ?>
                        <option><?= htmlspecialchars($ch['channel_name']) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>

        </div>

        <!-- بيانات النظام -->
        <div class="section-title">⚙️ بيانات النظام</div>

        <div class="row g-3">

            <div class="col-md-6">
                <label class="form-label">اسم مستخدم التطبيق</label>
                <input type="text" name="app_username" class="form-control">
            </div>

            <div class="col-md-6">
                <label class="form-label">الرمز السري للتطبيق</label>
                <input type="text" name="app_password" class="form-control">
            </div>

            <div class="col-md-6">
                <label class="form-label">هل يرغب بالسكن الداخلي؟</label>
                <select name="dorm" class="form-control">
                    <option>نعم</option>
                    <option>كلا</option>
                </select>
            </div>

        </div>

        <div class="text-center mt-4">
            <button class="btn-main">➕ إضافة الطالب</button>
        </div>

    </form>

</div>

</div>

<?php require_once "includes/footer.php"; ?>