<?php
session_start();
require_once "../config/db.php";
require_once "../config/security.php";
guard_admin();

$page_title = "تحليلات التسجيل – Analytics Pro v5";

// ===============================
//        Queries
// ===============================
$students = $conn->query("
    SELECT college_name, study_type, status, DATE(created_at) AS d
    FROM students
")->fetchAll(PDO::FETCH_ASSOC);

// حساب عدد التسجيل اليومي
$daily = [];
foreach ($students as $s){
    $day = $s['d'];
    $daily[$day] = ($daily[$day] ?? 0) + 1;
}

// حساب الأقسام
$departments = [];
foreach ($students as $s){
    $dept = $s['college_name'];
    $departments[$dept] = ($departments[$dept] ?? 0) + 1;
}

// حساب الحالات
$status_count = [
    "pending" => 0,
    "verified" => 0,
    "accepted" => 0
];
foreach ($students as $s){
    $status_count[$s["status"]] += 1;
}

include "includes/header.php";

?>

<style>
body { background: #0d0f17 !important; }

.card-glass {
    background: rgba(255,255,255,0.06);
    border-radius: 22px;
    padding: 25px;
    border: 1px solid rgba(255,255,255,0.12);
    backdrop-filter: blur(12px);
}

.analytics-title {
    color: white;
    font-size: 32px;
    font-weight: bold;
    margin-bottom: 25px;
}

.chart-card-title {
    color: #e5e7eb;
    font-size: 20px;
    margin-bottom: 12px;
}

/* Heatmap */
.heatmap-box {
    width: 22px;
    height: 22px;
    display: inline-block;
    margin: 3px;
    border-radius: 6px;
}
</style>

<div class="content">
<?php include "includes/navbar.php"; ?>

<div class="container-fluid mt-4">

<h2 class="analytics-title">📊 تحليلات التسجيل – Apple UI</h2>


<!-- =============================== -->
<!--        CHART ROW 1             -->
<!-- =============================== -->
<div class="row g-4">

    <div class="col-md-4">
        <div class="card-glass">
            <h4 class="chart-card-title">📈 حالات الطلاب</h4>
            <canvas id="statusChart"></canvas>
        </div>
    </div>

    <div class="col-md-8">
        <div class="card-glass">
            <h4 class="chart-card-title">📅 التسجيل اليومي</h4>
            <canvas id="dailyChart"></canvas>
        </div>
    </div>

</div>


<!-- =============================== -->
<!--         CHART ROW 2            -->
<!-- =============================== -->
<div class="row g-4 mt-1">

    <div class="col-md-6">
        <div class="card-glass">
            <h4 class="chart-card-title">🏛️ شارت Radar للأقسام</h4>
            <canvas id="deptRadar"></canvas>
        </div>
    </div>

    <div class="col-md-6">
        <div class="card-glass">
            <h4 class="chart-card-title">🔥 شارت Trendline (التحسن)</h4>
            <canvas id="trendChart"></canvas>
        </div>
    </div>

</div>


<!-- =============================== -->
<!--             HEATMAP             -->
<!-- =============================== -->
<div class="card-glass mt-4">
    <h4 class="chart-card-title">🟩 خريطة كثافة التسجيل (مثل GitHub)</h4>

    <?php
    foreach($daily as $day => $val){
        $color = "#1e3a8a";
        if($val >= 1 && $val <= 2) $color = "#0ea5e9";
        if($val >= 3 && $val <= 5) $color = "#0284c7";
        if($val >= 6)             $color = "#0369a1";

        echo "<span class='heatmap-box' style='background:$color' title='$day: $val تسجيل'></span>";
    }
    ?>
</div>

</div>
</div>

<?php include "includes/footer.php"; ?>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
// ================== STATUS ==================
new Chart(document.getElementById("statusChart"), {
    type: "doughnut",
    data: {
        labels: ["غير مدقق","مدقق","مقبول"],
        datasets: [{
            data: [
                <?= $status_count['pending'] ?>,
                <?= $status_count['verified'] ?>,
                <?= $status_count['accepted'] ?>
            ],
            backgroundColor: ["#FFD60A","#0A84FF","#30D158"],
            borderWidth: 2,
            hoverOffset: 10
        }]
    }
});

// ================== DAILY ==================
new Chart(document.getElementById("dailyChart"), {
    type: "line",
    data: {
        labels: [<?php foreach($daily as $d => $v) echo "'$d',"; ?>],
        datasets: [{
            label: "عدد المسجلين",
            data: [<?php foreach($daily as $d => $v) echo "$v,"; ?>],
            borderColor: "#0A84FF",
            borderWidth: 3,
            fill: true,
            backgroundColor: "rgba(14,122,254,0.2)",
            tension: 0.4
        }]
    }
});

// ================== RADAR ==================
new Chart(document.getElementById("deptRadar"), {
    type: "radar",
    data: {
        labels: [<?php foreach($departments as $d => $v) echo "'$d',"; ?>],
        datasets: [{
            label: "عدد الطلاب",
            data: [<?php foreach($departments as $d => $v) echo "$v,"; ?>],
            backgroundColor: "rgba(191,90,242,0.2)",
            borderColor: "#BF5AF2",
            pointBackgroundColor: "#FFD60A",
            borderWidth: 2
        }]
    }
});

// ================== TREND ==================
new Chart(document.getElementById("trendChart"), {
    type: "bar",
    data: {
        labels: [<?php foreach($daily as $d => $v) echo "'$d',"; ?>],
        datasets: [{
            label: "تسجيل",
            data: [<?php foreach($daily as $d => $v) echo "$v,"; ?>],
            backgroundColor: "#30D158",
        }]
    }
});
</script>