<?php
session_start();
require_once "../../config/db.php";
require_once "../../config/security.php";
require_once "functions_backup.php";
require_once "config.php";

if (!isset($_SESSION['admin_logged_in'])) die("غير مصرح");

$error = "";
$filename = "";

$path = create_full_backup($filename, $error);

if (!$path) {
    sendTelegram($TELEGRAM_BOT_TOKEN, $TELEGRAM_CHAT_ID,
        "❌ <b>فشل إنشاء النسخة الاحتياطية</b>\nالسبب: $error"
    );

    die("<div class='alert alert-danger'>$error</div>");
}

// إرسال رسالة ناجحة
sendTelegram($TELEGRAM_BOT_TOKEN, $TELEGRAM_CHAT_ID,
"📦 <b>تم إنشاء نسخة احتياطية جديدة</b>\n
💾 الملف: <code>$filename</code>\n
📏 الحجم: " . round(filesize($path)/1024/1024,2) . " MB\n
🕒 الوقت: " . date('Y-m-d H:i')
);

// رفع خارجي
if ($REMOTE_BACKUP_URL) {
    upload_to_external($path, $filename, $REMOTE_BACKUP_URL);
}

echo "<div class='alert alert-success'>✔ تم إنشاء النسخة: $filename</div>";
echo "<a class='btn btn-secondary mt-3' href='index.php'>رجوع</a>";
?>