<?php
session_start();
require_once "../../config/db.php";
require_once "../../config/security.php";

// تأكيد تسجيل الدخول
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: ../login.php");
    exit;
}

// جلب جميع السجلات
$logs = [];
try {
    $stmt = $conn->query("SELECT * FROM backup_logs ORDER BY id DESC");
    $logs = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    $logs = [];
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">

<title>سجل النسخ الاحتياطية</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

<style>
body {
    font-family:"Tajawal",sans-serif;
    background:#f5f7fb;
}

.layout-wrapper {
    min-height:100vh;
    display:flex;
}

.sidebar {
    width:250px;
    background:#fff;
    border-right:1px solid #e5e7eb;
    box-shadow:0 0 25px rgba(15,23,42,0.08);
}

.sidebar-header {
    padding:18px 20px;
    border-bottom:1px solid #e5e7eb;
}

.sidebar-title {
    font-size:17px;
    font-weight:700;
    display:flex;
    align-items:center;
    gap:8px;
}

.sidebar-menu {
    list-style:none;
    padding:12px 0;
    margin:0;
}

.sidebar-menu li a {
    display:flex;
    align-items:center;
    gap:10px;
    padding:10px 20px;
    text-decoration:none;
    color:#4b5563;
    border-right:3px solid transparent;
}

.sidebar-menu li a:hover {
    background:#f0f7ff;
    color:#1d4ed8;
}

.sidebar-menu li a.active {
    background:#e0ecff;
    border-right-color:#2563eb;
    color:#1d4ed8;
    font-weight:600;
}

.main-content {
    flex:1;
    padding:25px;
}

.table thead th {
    background:#eef2ff;
    color:#1e3a8a;
    font-weight:700;
}

.badge-status {
    padding:4px 9px;
    font-size:11px;
    border-radius:8px;
}
.badge-ok {
    background:#d1fae5;
    color:#065f46;
}
.badge-warn {
    background:#fef3c7;
    color:#92400e;
}
.badge-err {
    background:#fee2e2;
    color:#991b1b;
}
</style>
</head>
<body>

<div class="layout-wrapper">

    <!-- سايدبار -->
    <aside class="sidebar">

        <div class="sidebar-header">
            <div class="sidebar-title">
                <i class="bi bi-hdd-stack"></i> إدارة النسخ الاحتياطية
            </div>
        </div>

        <ul class="sidebar-menu">
            <li><a href="index.php"><i class="bi bi-speedometer2"></i> نظرة عامة</a></li>
            <li><a href="create.php"><i class="bi bi-cloud-arrow-up"></i> إنشاء نسخة</a></li>
            <li><a href="restore.php"><i class="bi bi-arrow-counterclockwise"></i> استرجاع</a></li>
            <li><a href="settings.php"><i class="bi bi-gear"></i> الإعدادات</a></li>
            <li><a href="logs.php" class="active"><i class="bi bi-journal-text"></i> السجل</a></li>
        </ul>

    </aside>

    <!-- المحتوى -->
    <main class="main-content">

        <h3 class="mb-3"><i class="bi bi-journal-text me-1"></i> سجل النسخ الاحتياطية</h3>

        <div class="card shadow-sm">
            <div class="card-body">

                <?php if (empty($logs)): ?>
                    <div class="alert alert-warning text-center">⚠ لا توجد سجلات نسخ احتياطية حتى الآن.</div>
                <?php else: ?>

                <div class="table-responsive">
                    <table class="table table-bordered align-middle">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>اسم النسخة</th>
                                <th>الحجم</th>
                                <th>تاريخ الإنشاء</th>
                                <th>رابط خارجي</th>
                            </tr>
                        </thead>
                        <tbody>

                        <?php foreach ($logs as $row): ?>
                            <tr>
                                <td><?= $row['id'] ?></td>

                                <td>
                                    <code><?= htmlspecialchars($row['file_name']) ?></code>
                                </td>

                                <td>
                                    <?= round($row['file_size']/1024/1024,2) ?> MB
                                </td>

                                <td><?= $row['created_at'] ?></td>

                                <td>
                                    <?php if (!empty($row['drive_url'])): ?>
                                        <a href="<?= $row['drive_url'] ?>" class="btn btn-sm btn-primary" target="_blank">
                                            <i class="bi bi-box-arrow-up-right"></i> فتح
                                        </a>
                                    <?php else: ?>
                                        <span class="badge badge-status badge-warn">غير موجود</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>

                        </tbody>
                    </table>

                </div>

                <?php endif; ?>

            </div>
        </div>

    </main>

</div>

</body>
</html>