<?php
session_start();
require_once "../../config/db.php";
require_once "functions_backup.php";

$dir = __DIR__ . "/files/";
$files = array_diff(scandir($dir),['.','..']);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>النسخ الاحتياطية</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body class="bg-light">

<div class="container mt-4">

    <div class="card shadow-sm">
        <div class="card-header bg-white">
            <h4 class="fw-bold">📦 النسخ الاحتياطية</h4>
        </div>

        <div class="card-body">

            <a href="create.php" class="btn btn-primary mb-3">➕ إنشاء نسخة يدوياً</a>
            <a href="test_backup.php" class="btn btn-warning mb-3">🧪 زر تجربة الإرسال</a>
            <a href="settings.php" class="btn btn-secondary mb-3">⚙ الإعدادات</a>

            <table class="table table-bordered bg-white">
                <thead>
                    <tr>
                        <th>الملف</th>
                        <th>الحجم</th>
                        <th>التاريخ</th>
                        <th>عمليات</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach($files as $f): 
                    $full = $dir.$f; ?>
                    <tr>
                        <td><?= $f ?></td>
                        <td><?= round(filesize($full)/1024/1024,2) ?> MB</td>
                        <td><?= date("Y-m-d H:i", filemtime($full)) ?></td>
                        <td>
                            <a href="files/<?= $f ?>" download class="btn btn-sm btn-success">⬇️</a>
                            <a href="restore.php?file=<?= urlencode($f) ?>" class="btn btn-sm btn-danger">🔄 استرجاع</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>

        </div>
    </div>

</div>

</body>
</html>