<?php
session_start();
require_once "../../config/db.php";
require_once "../../config/security.php";

if (!isset($_SESSION['admin_logged_in'])) die("غير مصرح");

$success = "";

// حفظ الإعدادات
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    foreach ($_POST as $k => $v) {
        $stmt = $conn->prepare("
            INSERT INTO backup_settings (key_name, key_value)
            VALUES (?, ?)
            ON DUPLICATE KEY UPDATE key_value = VALUES(key_value)
        ");
        $stmt->execute([$k, $v]);
    }

    $success = "✔ تم حفظ الإعدادات";
}

// جلب القيم
$token  = get_setting("telegram_token", "");
$chatid = get_setting("telegram_chat_id", "");
$url    = get_setting("external_url", "");

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>إعدادات النسخ</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="p-4">

<h3>⚙ إعدادات النسخ الاحتياطية</h3>

<?php if ($success): ?>
<div class="alert alert-success"><?= $success ?></div>
<?php endif; ?>

<form method="POST">

    <label class="mt-3">توكن تليجرام</label>
    <input type="text" name="telegram_token" class="form-control" value="<?= $token ?>">

    <label class="mt-3">Chat ID</label>
    <input type="text" name="telegram_chat_id" class="form-control" value="<?= $chatid ?>">

    <label class="mt-3">رابط السيرفر الخارجي</label>
    <input type="text" name="external_url" class="form-control" value="<?= $url ?>">

    <button class="btn btn-primary mt-4">💾 حفظ</button>

</form>

</body>
</html>