<?php
session_start();
require_once "../../config/db.php";
require_once "../../config/security.php";

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: ../login.php");
    exit;
}

$success = "";
$error = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {

    $channel_name = sanitize($_POST['channel_name']);

    if (empty($channel_name)) {
        $error = "❌ يجب كتابة اسم القناة.";
    } else {
        $stmt = $conn->prepare("INSERT INTO channels (channel_name) VALUES (?)");
        $stmt->execute([$channel_name]);
        $success = "✔ تمت إضافة القناة بنجاح!";
    }
}

// عنوان الصفحة
$page_title = "إضافة قناة تقديم";

// الهيدر + النافبار
require_once "../includes/header.php";
require_once "../includes/navbar.php";
?>

<style>
body {
    background: radial-gradient(circle at top,#0f172a,#1e1b4b);
    font-family:"Tajawal";
    color:white;
}

.glass-box {
    max-width:500px;
    margin:40px auto;
    background:rgba(255,255,255,0.07);
    padding:30px;
    border-radius:20px;
    border:1px solid rgba(255,255,255,0.2);
}

/* ⭐ لون الحقول الجديد */
.form-control {
    background: rgba(14, 165, 233, 0.25) !important;
    border:1px solid rgba(255,255,255,0.25) !important;
    color:white !important;
    border-radius:12px;
}

.form-control::placeholder {
    color:#dbeafe !important;
}

/* زر الإضافة */
.btn-main {
    background:linear-gradient(90deg,#3b82f6,#6366f1);
    border:0;
    color:white;
    border-radius:12px;
    padding:12px;
    font-weight:700;
}

/* رسائل النجاح والخطأ */
.success-box, .error-box {
    padding:10px;
    border-radius:10px;
    margin-bottom:15px;
    text-align:center;
}
.success-box { background:rgba(16,185,129,0.3); }
.error-box   { background:rgba(239,68,68,0.3); }
</style>

<div class="page-content">

    <div class="glass-box">

        <?php if ($success): ?>
            <div class="success-box"><?= $success ?></div>
        <?php endif; ?>

        <?php if ($error): ?>
            <div class="error-box"><?= $error ?></div>
        <?php endif; ?>

        <form method="POST">

            <label class="mb-1">اسم القناة</label>
            <input type="text" name="channel_name"
                   class="form-control mb-3"
                   placeholder="أدخل اسم القناة..." required>

            <button class="btn-main w-100">💾 حفظ</button>

        </form>

    </div>

</div>

<?php require_once "../includes/footer.php"; ?>