<?php
session_start();
require_once "../../config/db.php";
require_once "../../config/security.php";

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: ../login.php");
    exit;
}

$success = "";
$error = "";

// عند إرسال النموذج
if ($_SERVER["REQUEST_METHOD"] === "POST") {

    $university_name = sanitize($_POST['university_name']);
    $college_name    = sanitize($_POST['college_name']);
    $study_type      = sanitize($_POST['study_type']);
    $fee             = intval($_POST['fee']); // ⭐ تمت الإضافة سابقاً

    if (empty($college_name)) {
        $error = "❌ يجب كتابة اسم الكلية أو القسم.";
    } else {

        $stmt = $conn->prepare("
            INSERT INTO colleges (university_name, college_name, study_type, fee)
            VALUES (?, ?, ?, ?)
        ");

        $stmt->execute([$university_name, $college_name, $study_type, $fee]);

        $success = "✔ تم إضافة الكلية بنجاح!";
    }
}

// عنوان الصفحة
$page_title = "إضافة كلية / قسم جديد";

// تحميل الهيدر + النافبار
require_once "../includes/header.php";
require_once "../includes/navbar.php";
?>

<style>
/* نفس التصميم الأصلي دون أي تغيير */
body {
    background: radial-gradient(circle at top,#0f172a,#1e1b4b);
    font-family:"Tajawal";
    color:white;
}

.glass-box {
    max-width:600px;
    margin:40px auto;
    background:rgba(255,255,255,0.07);
    padding:30px;
    border-radius:20px;
    border:1px solid rgba(255,255,255,0.2);
    box-shadow:0 10px 40px rgba(0,0,0,0.45);
}

.form-control, select {
    background:rgba(255,255,255,0.15);
    border:1px solid rgba(255,255,255,0.3);
    color:white;
    border-radius:12px;
}
label { font-weight:600; }

.btn-main {
    background:linear-gradient(90deg,#3b82f6,#6366f1);
    border:0;
    padding:12px;
    border-radius:12px;
    font-weight:700;
    color:white;
    width:100%;
}

.success-box {
    background:rgba(16,185,129,0.25);
    border:1px solid rgba(16,185,129,0.4);
    padding:12px;
    border-radius:12px;
    text-align:center;
    color:#bbf7d0;
    margin-bottom:20px;
}

.error-box {
    background:rgba(239,68,68,0.25);
    border:1px solid rgba(239,68,68,0.4);
    padding:12px;
    border-radius:12px;
    text-align:center;
    color:#fecaca;
    margin-bottom:20px;
}
</style>

<div class="page-content">

    <div class="glass-box">

    <?php if ($success): ?>
        <div class="success-box"><?= $success ?></div>
    <?php endif; ?>

    <?php if ($error): ?>
        <div class="error-box"><?= $error ?></div>
    <?php endif; ?>

    <form method="POST">

        <label class="mb-1">اسم الجامعة</label>
        <input type="text" name="university_name" class="form-control mb-3" 
            value="جامعة النبراس" required>

        <label class="mb-1">اسم الكلية / القسم</label>
        <input type="text" name="college_name" class="form-control mb-3" required>

        <label class="mb-1">نوع الدراسة</label>
        <select name="study_type" class="form-control mb-3" required>
            <option value="صباحي">صباحي</option>
            <option value="مسائي">مسائي</option>
        </select>

        <label class="mb-1">قسط السنة (IQD)</label>
        <input type="number" name="fee" class="form-control mb-3" required>

        <button class="btn-main mt-3">💾 إضافة الكلية</button>

    </form>

    </div>

</div>

<?php require_once "../includes/footer.php"; ?>