<?php
session_start();
require_once "../config/db.php";

if (!isset($_SESSION['admin_logged_in'])) die("Access denied.");

if (!isset($_GET['id'])) die("Invalid request.");

$id = intval($_GET['id']);
$sid = intval($_GET['sid']);

$stmt = $conn->prepare("SELECT pdf_path FROM student_pdf WHERE id=? LIMIT 1");
$stmt->execute([$id]);
$pdf = $stmt->fetch(PDO::FETCH_ASSOC);

if ($pdf) {
    $file = "../uploads/pdfs/" . $pdf["pdf_path"];
    if (file_exists($file)) unlink($file);

    $del = $conn->prepare("DELETE FROM student_pdf WHERE id=?");
    $del->execute([$id]);
}

header("Location: student_view.php?id=$sid");
exit;
?>