<?php
/********************************************************************
 *  FIELD LOADER  
 *  تحميل الحقول الديناميكية وإرجاعها مجمّعة حسب القسم
 ********************************************************************/

require_once "../../config/db.php";
require_once "../../config/security.php";

function load_dynamic_fields($section_name) {
    global $conn;

    $stmt = $conn->prepare("
        SELECT *
        FROM fields
        WHERE section_name = ?
        ORDER BY order_number ASC
    ");
    $stmt->execute([$section_name]);

    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

/********************************************************************
 *  HTML Generator
 *  يولّد عنصر form HTML حسب نوع الحقل المخزّن في الـ SQL
 ********************************************************************/
function render_field_html($field, $value = "") {

    $required = $field['is_required'] ? "required" : "";
    $label    = htmlspecialchars($field['field_label']);
    $name     = htmlspecialchars($field['field_name']);
    $type     = $field['field_type'];

    // تحويل الخيارات إلى مصفوفة
    $options = [];
    if (!empty($field['options'])) {
        $options = explode("\n", trim($field['options']));
    }

    // HTML output
    $html = "<div class='col-md-6'>";
    $html .= "<label class='form-label'>{$label}</label>";

    switch ($type) {

        case "text":
        case "number":
        case "date":
        case "time":
            $html .= "<input type='{$type}' name='{$name}' value='{$value}' class='form-control' {$required}>";
            break;

        case "textarea":
            $html .= "<textarea name='{$name}' class='form-control' {$required}>{$value}</textarea>";
            break;

        case "select":
            $html .= "<select name='{$name}' class='form-control' {$required}>";
            foreach ($options as $op) {
                $op_clean = trim($op);
                $selected = ($value == $op_clean) ? "selected" : "";
                $html .= "<option {$selected}>{$op_clean}</option>";
            }
            $html .= "</select>";
            break;

        case "radio":
            foreach ($options as $op) {
                $op_clean = trim($op);
                $checked  = ($value == $op_clean) ? "checked" : "";
                $html .= "
                    <div>
                        <label>
                            <input type='radio' name='{$name}' value='{$op_clean}' {$checked} {$required}>
                            {$op_clean}
                        </label>
                    </div>";
            }
            break;

        case "checkbox":
            foreach ($options as $op) {
                $op_clean = trim($op);
                $checked  = (strpos($value, $op_clean) !== false) ? "checked" : "";
                $html .= "
                    <div>
                        <label>
                            <input type='checkbox' name='{$name}[]' value='{$op_clean}' {$checked}>
                            {$op_clean}
                        </label>
                    </div>";
            }
            break;

        case "file":
            $html .= "<input type='file' name='{$name}' class='form-control' {$required}>";
            break;

        case "hidden":
            $html .= "<input type='hidden' name='{$name}' value='{$value}'>";
            break;

        default:
            $html .= "<input type='text' name='{$name}' value='{$value}' class='form-control'>";
    }

    $html .= "</div>";

    return $html;
}
?>
