<?php
session_start();
require_once "../../config/db.php";

if (!isset($_SESSION['admin_logged_in'])) { header("Location: ../login.php"); exit; }

if ($_SERVER["REQUEST_METHOD"]=="POST") {

    $order = json_decode($_POST['order'], true);

    foreach ($order as $pos => $id) {
        $stmt = $conn->prepare("UPDATE fields SET order_number=? WHERE id=?");
        $stmt->execute([$pos,$id]);
    }

    echo "done";
    exit;
}

$fields = $conn->query("SELECT * FROM fields ORDER BY order_number ASC")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar">
<head>
<meta charset="UTF-8">
<title>ترتيب الحقول</title>
<script src="https://cdnjs.cloudflare.com/ajax/libs/Sortable/1.15.0/Sortable.min.js"></script>

<style>
body { background:#0f172a;color:white;font-family:Tajawal; }
.item { padding:10px;background:#1e293b;margin-bottom:5px;border-radius:8px;cursor:grab; }
</style>
</head>
<body>

<h3 class="text-center mt-4">🔀 ترتيب الحقول</h3>

<div class="container mt-4" style="max-width:600px;">
    <div id="items">
        <?php foreach ($fields as $f): ?>
            <div class="item" data-id="<?= $f['id'] ?>">
                <?= $f['field_label'] ?> <span class="text-info">(<?= $f['field_type'] ?>)</span>
            </div>
        <?php endforeach; ?>
    </div>

    <button id="save" class="btn btn-primary mt-3">💾 حفظ</button>
</div>

<script>
new Sortable(document.getElementById("items"), { animation:150 });

document.getElementById("save").onclick = function(){
    let ids = [];
    document.querySelectorAll(".item").forEach(el => ids.push(el.dataset.id));

    let form = new FormData();
    form.append("order", JSON.stringify(ids));

    fetch("", { method:"POST", body:form })
    .then(r=>r.text())
    .then(x => alert("✔ تم الحفظ"));
}
</script>

</body>
</html>
