<?php
require_once __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/../config/db.php';
use Mpdf\Mpdf;

/*================= فحص ID =================*/
if (!isset($_GET['id'])) {
    die("❌ Student ID not provided.");
}

$student_id = intval($_GET['id']);

/*================= جلب بيانات الطالب =================*/
$stmt = $conn->prepare("
    SELECT 
        full_name,
        exam_number,
        graduation_year,
        exam_round,
        branch,
        secret_number,
        college_name,
        university_name,
        study_type
    FROM students
    WHERE id = ?
    LIMIT 1
");

$stmt->execute([$student_id]);
$data = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$data) {
    die("❌ Student not found.");
}

/*================= إعداد mPDF =================*/
$mpdf = new Mpdf([
    'mode' => 'utf-8',
    'format' => 'A4',
    'default_font' => 'dejavusans',
    'margin_left' => 10,
    'margin_right' => 10,
    'margin_top' => 45,
    'margin_bottom' => 10,
    'tempDir' => __DIR__ . '/../tmp'
]);

/*================= الشعار والعلامة المائية =================*/
$logoPath      = realpath(__DIR__ . '/../assets/img/logo.png');
$watermarkPath = realpath(__DIR__ . '/../assets/img/watermark.png');

$logoUrl = "file://" . $logoPath;

if ($watermarkPath) {
    $mpdf->SetWatermarkImage(
        $watermarkPath,
        0.10,
        [180, 170],
        -25
    );
    $mpdf->showWatermarkImage = true;
}

/*================= الهيدر =================*/
$headerHTML = '
<table width="100%" style="font-family:dejavusans;font-size:13px;">
<tr>

<td width="33%" style="text-align:right;font-weight:bold;line-height:1.5;">
جمهورية العراق<br>
وزارة التعليم العالي والبحث العلمي<br>
دائرة التعليم الجامعي الأهلي<br>
جامعة النبراس الأهلية<br>
قسم التسجيل
</td>

<td width="33%" style="text-align:center;">
    <img src="'.$logoUrl.'" width="120">
</td>

<td width="33%" style="text-align:left;direction:ltr;font-weight:bold;line-height:1.5;">
Republic of Iraq<br>
Ministry of Higher Education<br>
and Scientific Research<br>
Private Education Directorate<br>
Al-Nibras University<br>
Registration Department
</td>

</tr>
</table>

<hr style="border-top:2px solid #000;margin-top:6px;">
';

$mpdf->SetHTMLHeader($headerHTML);

/*================= HTML =================*/
$html = '
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<style>

body {
    font-family: dejavusans;
    font-size: 16px;
    line-height: 1.6;
    direction: rtl;
}

.title {
    text-align:center;
    font-size: 20px;
    font-weight:bold;
    margin: 15px 0;
    text-decoration: underline;
}

table.data {
    width:100%;
    border-collapse: collapse;
    margin-top: 10px;
}

table.data td {
    border: 1px solid #000;
    padding: 10px 8px;
    font-size: 16px;
}

.label { font-weight: bold; text-align: right; }
.inner { text-align: right; font-weight: bold; }

.footer-seal {
    margin-top: 30px;
    font-size: 17px;
    font-weight:bold;
    text-align:right;
}

</style>
</head>

<body>

<div class="title">استمارة المعلومات</div>

<table class="data">

<tr>
    <td class="label">اسم الطالب</td>
    <td colspan="3" class="inner">'.$data['full_name'].'</td>
</tr>

<tr>
    <td class="label">الرقم الامتحاني</td>
    <td colspan="3" class="inner">'.$data['exam_number'].'</td>
</tr>

<tr>
    <td class="label">سنة التخرج</td>
    <td class="inner">'.$data['graduation_year'].'</td>

    <td class="label">الدور</td>
    <td class="inner">'.$data['exam_round'].'</td>
</tr>

<tr>
    <td class="label">الفرع</td>
    <td class="inner">'.$data['branch'].'</td>

    <td class="label">رقم الكود</td>
    <td class="inner">'.$data['secret_number'].'</td>
</tr>

<tr>
    <td class="label">الكلية / القسم</td>
    <td colspan="3" class="inner">'.$data['college_name'].'</td>
</tr>

</table>

<div class="footer-seal">ختم وتوقيع موظف التسجيل</div>

</body>
</html>
';

$mpdf->WriteHTML($html);
$mpdf->Output("student_form_".$student_id.".pdf", "I");
exit;