<?php
if (!isset($_SESSION)) session_start();

// منع الدخول بدون تسجيل
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: ../login.php");
    exit;
}

require_once __DIR__ . "/../../config/app.php";
require_once __DIR__ . "/../../config/db.php";
require_once __DIR__ . "/../../config/security.php";

$page_title = isset($page_title) ? $page_title : "لوحة مدير التسجيل";
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">

<title><?= htmlspecialchars($page_title, ENT_QUOTES, 'UTF-8') ?></title>

<!-- Tajawal Font -->
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;700;800&display=swap" rel="stylesheet">

<!-- Bootstrap -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">

<!-- Icons -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

<style>
:root {
    --nav-height: 78px;
    --bg-main: #020617;       /* خلفية عامة داكنة */
    --bg-surface: rgba(15,23,42,0.9);
    --border-soft: rgba(148,163,184,0.35);
    --accent: #38bdf8;
    --accent-soft: rgba(56,189,248,0.12);
    --text-main: #f9fafb;
    --text-muted: #94a3b8;
}

*,
*::before,
*::after {
    box-sizing: border-box;
}

body {
    margin: 0;
    padding: 0;
    background: radial-gradient(circle at top left, #0f172a 0, #020617 45%, #000 100%);
    font-family: "Tajawal", system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
    color: var(--text-main);
}

/* ====== NAVBAR العلوي (بدل السايدبار) ====== */
.app-navbar {
    position: fixed;
    inset-inline: 0;          /* right & left مع دعم RTL */
    top: 0;
    z-index: 1030;
    backdrop-filter: blur(18px);
    background: linear-gradient(90deg, rgba(15,23,42,0.96), rgba(30,64,175,0.92));
    border-bottom: 1px solid rgba(148,163,184,0.35);
    box-shadow: 0 10px 40px rgba(15,23,42,0.85);
}

/* مساحة المحتوى أسفل النافبار */
.page-content,
.main-content,
.content {
    padding: 24px;
    margin-top: calc(var(--nav-height) + 20px);
    min-height: calc(100vh - var(--nav-height));
}

/* كروت زجاجية */
.card-glass {
    background: radial-gradient(circle at top left, rgba(248,250,252,0.06), rgba(15,23,42,0.96));
    border-radius: 18px;
    padding: 20px 22px;
    border: 1px solid rgba(148,163,184,0.45);
    box-shadow: 0 20px 60px rgba(15,23,42,0.9);
    margin-bottom: 20px;
}

/* سكشنات داخل الكروت */
.section-title {
    font-size: 16px;
    font-weight: 700;
    color: #e5e7eb;
    margin-bottom: 10px;
}

/* Badges صغيرة */
.badge-soft {
    border-radius: 999px;
    padding: 4px 10px;
    font-size: 11px;
    background: var(--accent-soft);
    color: var(--accent);
    border: 1px solid rgba(56,189,248,0.35);
}

/* جداول */
.table-glass {
    border-radius: 14px;
    overflow: hidden;
    border: 1px solid rgba(148,163,184,0.35);
}
.table-glass thead {
    background: radial-gradient(circle at top, rgba(30,64,175,0.8), rgba(15,23,42,0.98));
    color: #e5e7eb;
}
.table-glass tbody tr {
    background: rgba(15,23,42,0.96);
    color: #e5e7eb;
}
.table-glass tbody tr:nth-child(even) {
    background: rgba(15,23,42,0.9);
}
.table-glass tbody tr:hover {
    background: rgba(30,64,175,0.35);
}

/* أزرار */
.btn-soft {
    border-radius: 999px;
    border: 1px solid rgba(148,163,184,0.35);
    background: rgba(15,23,42,0.9);
    color: #e5e7eb;
    font-size: 13px;
    padding-inline: 14px;
}
.btn-soft:hover {
    background: rgba(30,64,175,0.85);
    color: #f9fafb;
}

/* Scrollbar خفيف */
::-webkit-scrollbar {
    width: 8px;
}
::-webkit-scrollbar-track {
    background: #020617;
}
::-webkit-scrollbar-thumb {
    background: #1f2937;
    border-radius: 999px;
}
::-webkit-scrollbar-thumb:hover {
    background: #4b5563;
}

/* موبايل */
@media (max-width: 768px) {
    .page-content,
    .main-content,
    .content {
        padding: 16px;
        margin-top: calc(var(--nav-height) + 12px);
    }
}
/* ===== إصلاح حركة الحقول داخل النافبار ===== */

/* كل الروابط نفس الارتفاع */
.navbar .nav-link {
    padding: 10px 16px !important;
    font-size: 14px !important;
    font-weight: 500;
    line-height: 1 !important;
    display: flex;
    align-items: center;
    gap: 6px;
    transition: background 0.25s, color 0.25s;
}

/* شكل موحد للأيقونات */
.navbar .nav-link i {
    font-size: 16px !important;
    line-height: 1 !important;
    display: inline-flex;
    align-items: center;
}

/* dropdown items ضبط */
.dropdown-menu .dropdown-item {
    padding: 10px 16px !important;
    font-size: 14px !important;
    font-weight: 500;
    display: flex;
    align-items: center;
    gap: 6px;
    line-height: 1 !important;
}

/* أيقونات داخل dropdown */
.dropdown-menu .dropdown-item i {
    font-size: 16px !important;
    line-height: 1 !important;
}

/* منع تمدد مفاجئ عند hover */
.navbar .nav-link:hover,
.dropdown-menu .dropdown-item:hover {
    background: rgba(255,255,255,0.08) !important;
    color: #fff !important;
}

/* إصلاح زر الـ Toggler في الموبايل */
.navbar-toggler {
    padding: 6px 10px !important;
}

/* ضبط الارتفاع الكلي للـ navbar */
.app-navbar {
    height: var(--nav-height);
    display: flex;
    align-items: center;
}
</style>
</head>
<body>