<?php
session_start();

// إظهار الأخطاء أثناء التطوير (احذفها عند رفع الموقع)
error_reporting(E_ALL);
ini_set("display_errors", 1);

require_once "../config/db.php";
require_once "../config/security.php";

// إذا المدير مسجل دخول مسبقاً → يذهب للوحة التحكم مباشرة
if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
    header("Location: dashboard.php");
    exit;
}

// عند إرسال النموذج
$error = "";
if ($_SERVER["REQUEST_METHOD"] === "POST") {

    $username = sanitize($_POST['username']);
    $password = sanitize($_POST['password']);

    $stmt = $conn->prepare("SELECT id, username, password, role FROM admins WHERE username=? LIMIT 1");
    $stmt->execute([$username]);
    $admin = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($admin && password_verify($password, $admin['password'])) {

        $_SESSION['admin_logged_in'] = true;
        $_SESSION['admin_id'] = $admin['id'];
        $_SESSION['admin_username'] = $admin['username'];
        $_SESSION['admin_role'] = $admin['role'];

        header("Location: dashboard.php");
        exit;
    } else {
        $error = "❌ اسم المستخدم أو كلمة المرور غير صحيحة";
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>تسجيل دخول مدير التسجيل</title>

<!-- Bootstrap -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
body {
    margin: 0;
    min-height: 100vh;
    background: linear-gradient(135deg, #0f172a, #1e3a8a);
    display: flex;
    align-items: center;
    justify-content: center;
    font-family: "Tajawal", sans-serif;
    padding: 10px;
}

/* الكرت */
.login-card {
    width: 100%;
    max-width: 420px;
    padding: 40px 35px;
    border-radius: 20px;
    backdrop-filter: blur(18px);
    background: rgba(255, 255, 255, 0.06);
    border: 1px solid rgba(255, 255, 255, 0.15);
    box-shadow: 0 10px 45px rgba(0,0,0,0.55);
    animation: fadeIn 0.8s ease;
}

/* الشعار */
.university-logo {
    width: 130px;
    height: 130px;
    display: block;
    margin: 0 auto 15px;
    filter: drop-shadow(0 0 12px rgba(255,255,255,0.35));
}

/* النص */
h3 {
    font-size: 26px;
    color: white;
    font-weight: 800;
}

/* الليبل */
label {
    color: #e5e7eb;
    font-weight: 600;
}

/* المدخلات */
.form-control {
    border-radius: 12px;
    height: 48px;
    background: rgba(255,255,255,0.12);
    border: 1px solid rgba(255,255,255,0.20);
    color: #fff;
    font-size: 16px;
}
.form-control:focus {
    background: rgba(255,255,255,0.20);
    border-color: #3b82f6;
    color: #fff;
    box-shadow: none;
}

/* زر الدخول */
.btn-login {
    width: 100%;
    padding: 13px;
    border-radius: 14px;
    margin-top: 15px;
    background: linear-gradient(90deg, #3b82f6, #6366f1);
    color: #fff;
    font-weight: 700;
    font-size: 18px;
    border: none;
    display: flex;
    justify-content: center;
    gap: 8px;
    align-items: center;
}
.btn-login:hover {
    opacity: .93;
}

/* أنيميشن */
@keyframes fadeIn {
    from { opacity: 0; transform: translateY(20px); }
    to   { opacity: 1; transform: translateY(0); }
}
</style>

</head>
<body>

<div class="login-card">

    <img src="../assets/images/logo.png" class="university-logo" alt="Logo">

    <h3 class="text-center mb-4">تسجيل دخول مدير التسجيل</h3>

    <?php if (!empty($error)): ?>
        <div class="alert alert-danger text-center"><?= $error ?></div>
    <?php endif; ?>

    <form method="POST">

        <label class="mt-2">اسم المستخدم</label>
        <div class="input-group mb-3">
            <span class="input-group-text bg-transparent text-white border-0">
                <i class="bi bi-person-fill"></i>
            </span>
            <input type="text" name="username" class="form-control" required>
        </div>

        <label class="mt-2">كلمة المرور</label>
        <div class="input-group mb-3">
            <span class="input-group-text bg-transparent text-white border-0">
                <i class="bi bi-lock-fill"></i>
            </span>
            <input type="password" name="password" class="form-control" required>
        </div>

        <button class="btn-login">
            <i class="bi bi-box-arrow-in-right"></i>
            تسجيل دخول
        </button>

    </form>

</div>

</body>
</html>