<?php
session_start();
require_once "../../config/db.php";
require_once "../../config/security.php";

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: ../login.php");
    exit;
}

// دالة جلب إعداد
function get_builder_set($key, $default="") {
    global $conn;
    $stmt = $conn->prepare("SELECT key_value FROM builder_settings WHERE key_name=? LIMIT 1");
    $stmt->execute([$key]);
    $r = $stmt->fetchColumn();
    return $r ? $r : $default;
}

$success = "";

// حفظ الإعدادات
if ($_SERVER["REQUEST_METHOD"] === "POST") {

    foreach ($_POST as $key => $value) {

        $stmt = $conn->prepare("
            INSERT INTO builder_settings (key_name, key_value)
            VALUES (?, ?)
            ON DUPLICATE KEY UPDATE key_value=VALUES(key_value)
        ");

        $stmt->execute([$key, $value]);
    }

    $success = "✔ تم حفظ إعدادات Builder بنجاح!";
}

// جلب القيم الحالية
$allow_add_fields     = get_builder_set("allow_add_fields", "1");
$allow_delete_fields  = get_builder_set("allow_delete_fields", "1");
$auto_sql_migration   = get_builder_set("auto_sql_migration", "1");
$max_fields           = get_builder_set("max_fields", "200");
$allowed_types        = get_builder_set("allowed_types", "text,number,date,select,radio,checkbox,textarea,file");

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>إعدادات Form Builder</title>

<link rel="stylesheet"
href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">

<style>

body {
    background:#0f172a;
    font-family:"Tajawal";
    color:white;
}

.glass-box {
    max-width:900px;
    margin:40px auto;
    background:rgba(255,255,255,0.07);
    padding:30px;
    border-radius:20px;
    border:1px solid rgba(255,255,255,0.18);
    box-shadow:0 15px 45px rgba(0,0,0,0.45);
}

label { font-weight:600; }

.form-control {
    background:rgba(255,255,255,0.12);
    color:white;
    border:1px solid rgba(255,255,255,0.25);
    border-radius:12px;
}

.btn-main {
    background:linear-gradient(90deg,#3b82f6,#6366f1);
    padding:12px;
    border:0;
    width:100%;
    color:white;
    font-weight:700;
    border-radius:12px;
}

.success-box {
    background:rgba(16,185,129,0.25);
    padding:12px;border-radius:12px;
    color:#bbf7d0;
    border:1px solid rgba(16,185,129,0.4);
}

</style>

</head>
<body>

<?php include "../includes/header.php"; ?>

<?php include "../includes/navbar.php"; ?>

<div class="main-content">

<div class="glass-box">

    <h3 class="mb-4">🧱 إعدادات Form Builder</h3>

    <?php if ($success): ?>
        <div class="success-box mb-3"><?= $success ?></div>
    <?php endif; ?>

    <form method="POST">

        <div class="mb-4">
            <label>السماح بإضافة حقول جديدة</label><br>
            <select name="allow_add_fields" class="form-control">
                <option value="1" <?= $allow_add_fields=="1"?"selected":"" ?>>✔ نعم</option>
                <option value="0" <?= $allow_add_fields=="0"?"selected":"" ?>>❌ لا</option>
            </select>
        </div>

        <div class="mb-4">
            <label>السماح بحذف الحقول</label><br>
            <select name="allow_delete_fields" class="form-control">
                <option value="1" <?= $allow_delete_fields=="1"?"selected":"" ?>>✔ نعم</option>
                <option value="0" <?= $allow_delete_fields=="0"?"selected":"" ?>>❌ لا</option>
            </select>
        </div>

        <div class="mb-4">
            <label>إنشاء عمود SQL تلقائياً عند إضافة حقل</label><br>
            <select name="auto_sql_migration" class="form-control">
                <option value="1" <?= $auto_sql_migration=="1"?"selected":"" ?>>✔ تفعيل</option>
                <option value="0" <?= $auto_sql_migration=="0"?"selected":"" ?>>❌ إيقاف</option>
            </select>
        </div>

        <div class="mb-4">
            <label>الحد الأقصى لعدد الحقول</label>
            <input type="number" name="max_fields" class="form-control"
                   value="<?= $max_fields ?>">
        </div>

        <div class="mb-4">
            <label>أنواع الحقول المسموح إضافتها</label>
            <input type="text" name="allowed_types" class="form-control"
                   value="<?= htmlspecialchars($allowed_types) ?>">
            <small class="text-info">مثال: text,number,date,select,radio,checkbox,textarea,file</small>
        </div>

        <button class="btn-main mt-4">💾 حفظ الإعدادات</button>

    </form>

</div>

</div>

<?php include "../includes/footer.php"; ?>

</body>
</html>
