<?php
session_start();
require_once "../../config/db.php";
require_once "../../config/security.php";

guard_admin(); // حماية الدخول

// =============================
//       دالة جلب الإعداد
// =============================
function get_setting($key, $default = "") {
    global $conn;
    $stmt = $conn->prepare("SELECT setting_value FROM settings WHERE setting_key=? LIMIT 1");
    $stmt->execute([$key]);
    $r = $stmt->fetchColumn();
    return $r ?: $default;
}

// =============================
//        رسائل الحالة
// =============================
$success = "";
$error   = "";

// =============================
//      عند حفظ الإعدادات
// =============================
if ($_SERVER["REQUEST_METHOD"] === "POST") {

    $univ_name = sanitize($_POST['univ_name']);

    // حفظ اسم الجامعة
    $stmt = $conn->prepare("
        INSERT INTO settings (setting_key, setting_value)
        VALUES ('university_name', ?)
        ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)
    ");
    $stmt->execute([$univ_name]);

    // رفع شعار جديد
    if (!empty($_FILES['univ_logo']['name'])) {

        $ext = strtolower(pathinfo($_FILES['univ_logo']['name'], PATHINFO_EXTENSION));
        $allowed = ['png','jpg','jpeg','webp'];

        if (!in_array($ext, $allowed)) {
            $error = "❌ المسموح فقط (PNG – JPG – JPEG – WEBP)";
        } else {

            $file_name = "logo." . $ext;
            $path = "../../assets/images/" . $file_name;

            move_uploaded_file($_FILES['univ_logo']['tmp_name'], $path);

            $stmt = $conn->prepare("
                INSERT INTO settings (setting_key, setting_value)
                VALUES ('university_logo', ?)
                ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)
            ");
            $stmt->execute([$file_name]);
        }
    }

    if (!$error) {
        $success = "✔ تم حفظ الإعدادات بنجاح!";
    }
}

// =============================
//        القيم الحالية
// =============================
$current_name = get_setting("university_name", "جامعة النبراس");
$current_logo = get_setting("university_logo", "logo.png");

// عنوان الصفحة
$page_title = "إعدادات الجامعة";

// الهيدر + النافبار + السايدبار
require_once "../includes/header.php";
require_once "../includes/navbar.php";

?>

<style>
body {
    background:#0f172a;
    font-family:"Tajawal";
    color:white;
}

.main-content {
    padding:20px;
}

.glass-box {
    max-width:750px;
    margin:30px auto;
    background:rgba(255,255,255,0.07);
    padding:30px;
    border-radius:18px;
    border:1px solid rgba(255,255,255,0.15);
    box-shadow:0 10px 40px rgba(0,0,0,0.45);
}

.form-control {
    background:rgba(14,165,233,0.18) !important;
    border:1px solid rgba(255,255,255,0.25) !important;
    color:white !important;
    border-radius:12px;
    padding:12px;
}
.form-control::placeholder {
    color:#dbeafe;
}

.btn-main {
    background:linear-gradient(90deg,#3b82f6,#6366f1);
    border:0;
    padding:12px;
    color:white;
    width:100%;
    font-weight:700;
    border-radius:12px;
}

.success-box, .error-box {
    padding:12px;
    border-radius:12px;
    margin-bottom:15px;
    text-align:center;
}
.success-box {
    background:rgba(16,185,129,0.25);
    border:1px solid rgba(16,185,129,0.45);
    color:#bbf7d0;
}
.error-box {
    background:rgba(239,68,68,0.25);
    border:1px solid rgba(239,68,68,0.45);
    color:#fecaca;
}

.logo-preview {
    width:140px;
    margin-bottom:10px;
    border-radius:10px;
    border:2px solid rgba(255,255,255,0.3);
}
</style>

<div class="main-content">

    <div class="glass-box">
        <h3 class="mb-4">⚙ إعدادات الجامعة</h3>

        <?php if ($success): ?>
            <div class="success-box"><?= $success ?></div>
        <?php endif; ?>

        <?php if ($error): ?>
            <div class="error-box"><?= $error ?></div>
        <?php endif; ?>

        <form method="POST" enctype="multipart/form-data">

            <label class="mb-2">اسم الجامعة</label>
            <input type="text" name="univ_name"
                   class="form-control mb-4"
                   value="<?= htmlspecialchars($current_name) ?>" required>

            <label class="mb-2">الشعار الحالي</label><br>
            <img src="../../assets/images/<?= $current_logo ?>" class="logo-preview">

            <label class="mt-3 mb-2">رفع شعار جديد</label>
            <input type="file" name="univ_logo" class="form-control mb-4">

            <button class="btn-main">💾 حفظ الإعدادات</button>

        </form>

    </div>

</div>

<?php require_once "../includes/footer.php"; ?>