<?php
session_start();
require_once "../../config/db.php";
require_once "../../config/security.php";
require_once "../../config/app.php";

guard_admin();

// دالة لجلب إعداد PDF
function get_pdf_set($key, $default = "") {
    global $conn;
    $stmt = $conn->prepare("SELECT key_value FROM pdf_settings WHERE key_name=? LIMIT 1");
    $stmt->execute([$key]);
    $r = $stmt->fetchColumn();
    return $r ? $r : $default;
}

$success = "";
$error   = "";

// حفظ الإعدادات
if ($_SERVER["REQUEST_METHOD"] === "POST") {

    foreach ($_POST as $key => $value) {

        // تنظيف القيم
        $clean_key   = sanitize($key);
        $clean_value = is_array($value) ? "" : sanitize($value);

        $stmt = $conn->prepare("
            INSERT INTO pdf_settings (key_name, key_value)
            VALUES (?, ?)
            ON DUPLICATE KEY UPDATE key_value = VALUES(key_value)
        ");
        $stmt->execute([$clean_key, $clean_value]);
    }

    $success = "✔ تم حفظ إعدادات PDF بنجاح!";
}

// جلب الإعدادات الحالية
$header_right   = get_pdf_set("header_right", "جمهورية العراق<br>وزارة التعليم العالي والبحث العلمي<br>دائرة التعليم الجامعي الأهلي<br>جامعة النبراس الأهلية");
$header_left    = get_pdf_set("header_left", "Republic of Iraq<br>Ministry of Higher Education<br>Nebras University");
$title_text     = get_pdf_set("title_text", "استمارة المعلومات");
$footer_text    = get_pdf_set("footer_text", "ختم وتوقيع موظف التسجيل");
$font_size      = get_pdf_set("font_size", "14");
$margin_top     = get_pdf_set("margin_top", "15");
$margin_bottom  = get_pdf_set("margin_bottom", "15");
$margin_right   = get_pdf_set("margin_right", "15");
$margin_left    = get_pdf_set("margin_left", "15");

// عنوان الصفحة للـ header.php
$page_title = "إعدادات PDF الرسمي";

// الهيدر (عادة يحتوي النافبار + السايدبار لمشروعك)
require_once "../includes/header.php";
?>

<style>
body {
    background:#0f172a;
    font-family:"Tajawal";
    color:white;
}

.main-content {
    padding:20px;
}

.glass-box {
    max-width:900px;
    margin:40px auto;
    background:rgba(255,255,255,0.07);
    padding:30px;
    border-radius:20px;
    border:1px solid rgba(255,255,255,0.18);
    box-shadow:0 15px 45px rgba(0,0,0,0.45);
}

label { font-weight:600; }

textarea, .form-control {
    background:rgba(14,165,233,0.16);
    color:white;
    border:1px solid rgba(255,255,255,0.25);
    border-radius:12px;
}

textarea {
    min-height:110px;
}

.btn-main {
    background:linear-gradient(90deg,#3b82f6,#6366f1);
    padding:12px;
    border:0;
    width:100%;
    color:white;
    font-weight:700;
    border-radius:12px;
}

.success-box {
    background:rgba(16,185,129,0.25);
    padding:12px;border-radius:12px;
    color:#bbf7d0;
    border:1px solid rgba(16,185,129,0.4);
}

.error-box {
    background:rgba(239,68,68,0.25);
    padding:12px;border-radius:12px;
    color:#fecaca;
    border:1px solid rgba(239,68,68,0.4);
}
</style>
<?php include "../includes/header.php"; ?>

<?php include "../includes/navbar.php"; ?>

<div class="main-content">

    <div class="glass-box">

        <h3 class="mb-4">📝 إعدادات PDF الرسمي</h3>

        <?php if ($success): ?>
            <div class="success-box mb-3"><?= $success ?></div>
        <?php endif; ?>

        <?php if ($error): ?>
            <div class="error-box mb-3"><?= $error ?></div>
        <?php endif; ?>

        <form method="POST">

            <h5 class="mb-2">📌 نص الجهة اليمنى (عربي)</h5>
            <textarea name="header_right" rows="4" class="form-control mb-3"><?= htmlspecialchars($header_right) ?></textarea>

            <h5 class="mb-2">📌 نص الجهة اليسرى (إنكليزي)</h5>
            <textarea name="header_left" rows="4" class="form-control mb-3"><?= htmlspecialchars($header_left) ?></textarea>

            <h5 class="mb-2">📌 عنوان النموذج (وسط الصفحة)</h5>
            <input type="text" name="title_text" class="form-control mb-3"
                   value="<?= htmlspecialchars($title_text) ?>">

            <h5 class="mb-2">📌 النص السفلي (الختم والتوقيع)</h5>
            <input type="text" name="footer_text" class="form-control mb-4"
                   value="<?= htmlspecialchars($footer_text) ?>">

            <div class="row">
                <div class="col-md-3">
                    <label>حجم الخط</label>
                    <input type="number" name="font_size" class="form-control mb-3" value="<?= htmlspecialchars($font_size) ?>">
                </div>

                <div class="col-md-3">
                    <label>الهامش العلوي</label>
                    <input type="number" name="margin_top" class="form-control mb-3" value="<?= htmlspecialchars($margin_top) ?>">
                </div>

                <div class="col-md-3">
                    <label>الهامش السفلي</label>
                    <input type="number" name="margin_bottom" class="form-control mb-3" value="<?= htmlspecialchars($margin_bottom) ?>">
                </div>

                <div class="col-md-3">
                    <label>الهامش الأيمن</label>
                    <input type="number" name="margin_right" class="form-control mb-3" value="<?= htmlspecialchars($margin_right) ?>">
                </div>

                <div class="col-md-3">
                    <label>الهامش الأيسر</label>
                    <input type="number" name="margin_left" class="form-control mb-3" value="<?= htmlspecialchars($margin_left) ?>">
                </div>
            </div>

            <button class="btn-main mt-4">💾 حفظ الإعدادات</button>

        </form>

    </div>

</div>

<?php require_once "../includes/footer.php"; ?>