<?php
session_start();
require_once "../config/db.php";
require_once "../config/security.php";
include "includes/header.php";

// حماية المشرف
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit;
}

// فحص معرف الطالب
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("❌ معرف غير صالح.");
}

$id = intval($_GET['id']); // ← هذا هو المعرف الصحيح

/*============================= تنفيذ التدقيق =============================*/
if (isset($_GET['verify']) && $_GET['verify'] == 1) {
    $u = $conn->prepare("UPDATE students SET status='verified' WHERE id=?");
    $u->execute([$id]);
    header("Location: student_view.php?id=".$id);
    exit;
}

/*============================= جلب بيانات الطالب =============================*/
$stmt = $conn->prepare("SELECT * FROM students WHERE id=? LIMIT 1");
$stmt->execute([$id]);
$student = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$student) {
    die("❌ الطالب غير موجود.");
}

/*============================= جلب PDF واحد (اختياري) =============================*/
$pdf_stmt = $conn->prepare("SELECT pdf_path FROM student_pdf WHERE student_id=? LIMIT 1");
$pdf_stmt->execute([$id]);
$pdf_row = $pdf_stmt->fetch(PDO::FETCH_ASSOC);

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>ملف الطالب – <?= htmlspecialchars($student['full_name']) ?></title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

<style>
body {
    background:#0f172a;
    color:white;
    font-family:"Tajawal";
}

.navbar-custom {
    background:#1e293b;
    padding:15px;
    box-shadow:0 4px 20px rgba(0,0,0,0.4);
}
.navbar-custom h3 {
    margin:0;
    font-size:22px;
    font-weight:700;
}

.container-custom { max-width:1300px; margin:25px auto; }

.card-glass {
    background:rgba(255,255,255,0.07);
    border:1px solid rgba(255,255,255,0.12);
    border-radius:15px;
    padding:20px;
    margin-bottom:25px;
    backdrop-filter:blur(12px);
}

.section-title {
    font-size:20px;
    font-weight:700;
    margin-bottom:15px;
    color:#93c5fd;
}

.data-label {
    font-weight:700;
    color:#a5d8ff;
}
.data-value { padding:6px 0; }

.student-photo {
    width:100%;
    border-radius:15px;
    height:250px;
    object-fit:cover;
    border:2px solid rgba(255,255,255,0.3);
}

.timeline {
    background:#1e293b;
    border-radius:12px;
    padding:10px 15px;
}
.timeline-item { padding:10px 0; border-bottom:1px solid #334155; }
.timeline-item.active { color:#22c55e; font-weight:bold; }

.btn-action {
    font-size:18px;
    padding:12px 25px;
    border-radius:12px;
    font-weight:bold;
}

.btn-glass {
    background:rgba(255,255,255,0.08);
    border:1px solid rgba(255,255,255,0.2);
    color:white;
    border-radius:10px;
}
.btn-glass:hover { background:rgba(255,255,255,0.15); }

.table-dark th, .table-dark td { color:white!important; }
</style>
</head>

<body>

<!-- NAV -->
<div class="navbar-custom text-center text-white">
    <h3><i class="bi bi-person-vcard-fill"></i> ملف الطالب – <?= htmlspecialchars($student['full_name']) ?></h3>
</div>

<div class="container-custom">

<div class="row g-4">

    <!-- الصورة + الأزرار -->
    <div class="col-md-3">

        <div class="card-glass text-center">
            <?php if ($student['student_photo']): ?>
                <img src="../uploads/student_photos/<?= $student['student_photo'] ?>" class="student-photo">
            <?php else: ?>
                <div class="student-photo d-flex align-items-center justify-content-center bg-dark">
                    لا توجد صورة
                </div>
            <?php endif; ?>

            <div class="mt-3 d-grid gap-2">
                <a href="student_edit.php?id=<?= $id ?>" class="btn btn-warning btn-sm">
                    <i class="bi bi-pencil-square"></i> تعديل البيانات
                </a>

                <a href="upload_pdf.php?id=<?= $id ?>" class="btn btn-info btn-sm">
                    <i class="bi bi-filetype-pdf"></i> رفع استمارة PDF
                </a>

                <a href="generate_form.php?id=<?= $id ?>" target="_blank" class="btn btn-primary btn-sm">
                    <i class="bi bi-file-earmark-plus"></i> إنشاء استمارة جديدة
                </a>

                <?php if ($pdf_row): ?>
                <a href="../<?= $pdf_row['pdf_path'] ?>" target="_blank" class="btn btn-secondary btn-sm">
                    <i class="bi bi-eye-fill"></i> عرض الاستمارة المخزّنة
                </a>
                <?php endif; ?>

                <a href="student_delete.php?id=<?= $id ?>"
                   onclick="return confirm('حذف الطالب نهائياً؟');"
                   class="btn btn-danger btn-sm">
                    <i class="bi bi-trash"></i> حذف الطالب
                </a>
            </div>

            <a href="student_export_pdf.php?id=<?= $id ?>" 
               target="_blank"
               class="btn btn-danger btn-action mt-4">
               <i class="bi bi-filetype-pdf"></i> تصدير جميع بيانات الطالب PDF
            </a>
        </div>

        <!-- حالة الطالب -->
        <div class="card-glass">
            <div class="section-title"><i class="bi bi-bar-chart-steps"></i> مراحل الطلب</div>
            <div class="timeline">
                <div class="timeline-item <?= $student['status']=='pending'?'active':'' ?>">📝 بانتظار التدقيق</div>
                <div class="timeline-item <?= $student['status']=='verified'?'active':'' ?>">🔎 تم التدقيق</div>
                <div class="timeline-item <?= $student['status']=='accepted'?'active':'' ?>">🎓 الطالب مقبول</div>
            </div>
        </div>

    </div>

    <!-- بيانات الطالب -->
    <div class="col-md-9">

        <!-- معلومات شخصية -->
        <div class="card-glass">
            <div class="section-title"><i class="bi bi-person-lines-fill"></i> المعلومات الشخصية</div>
            <div class="row g-3">

                <?php
                $fields = [
                    "رقم الهوية / الجواز" => "national_or_passport",
                    "الهاتف" => "phone",
                    "اسم الأم" => "mother_name",
                    "الجنس" => "gender",
                    "البريد الإلكتروني" => "email",
                    "مكان الولادة" => "birth_place",
                    "العنوان" => "address",
                    "أقرب نقطة دالة" => "nearest_point"
                ];

                foreach ($fields as $label=>$col): ?>
                <div class="col-md-6">
                    <div class="data-label"><?= $label ?></div>
                    <div class="data-value"><?= htmlspecialchars($student[$col]) ?></div>
                </div>
                <?php endforeach; ?>

            </div>
        </div>

        <!-- المدرسة -->
        <div class="card-glass">
            <div class="section-title"><i class="bi bi-building"></i> معلومات المدرسة / الإعدادية</div>

            <div class="row g-3">
                <?php
                $sch = [
                    "اسم المدرسة" => "school_name",
                    "الفرع" => "branch",
                    "سنة التخرج" => "graduation_year",
                    "الدور" => "exam_round",
                    "المحاولات" => "attempts",
                    "سنوات الرسوب" => "fail_years",
                    "الرقم الامتحاني" => "exam_number",
                    "عدد الدروس" => "subjects_count",
                    "المجموع" => "total_score",
                    "المعدل" => "average"
                ];
                foreach ($sch as $label=>$col): ?>
                <div class="col-md-6">
                    <div class="data-label"><?= $label ?></div>
                    <div class="data-value"><?= htmlspecialchars($student[$col]) ?></div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- الجامعة -->
        <div class="card-glass">
            <div class="section-title"><i class="bi bi-mortarboard-fill"></i> الجامعة والكلية</div>

            <div class="row g-3">
                <?php
                $univ = [
                    "اسم الجامعة"  => "university_name",
                    "القسم"         => "college_name",
                    "نوع الدراسة"   => "study_type",
                    "قناة التقديم"  => "admission_channel"
                ];
                foreach ($univ as $label=>$col): ?>
                <div class="col-md-6">
                    <div class="data-label"><?= $label ?></div>
                    <div class="data-value"><?= htmlspecialchars($student[$col]) ?></div>
                </div>
                <?php endforeach; ?>

                <div class="col-md-12">
                    <div class="data-label">القسط السنوي</div>
                    <div class="data-value"><?= number_format($student['college_fee']) ?> د.ع</div>
                </div>
            </div>
        </div>

        <!-- بيانات النظام -->
        <div class="card-glass">
            <div class="section-title"><i class="bi bi-gear-fill"></i> بيانات النظام</div>

            <div class="row g-3">
                <?php
                $sys = [
                    "اسم المستخدم" => "app_username",
                    "كلمة المرور" => "app_password",
                    "سكن داخلي" => "dorm_request",
                    "حالة الطلب" => "status"
                ];
                foreach ($sys as $label=>$col): ?>
                <div class="col-md-6">
                    <div class="data-label"><?= $label ?></div>
                    <div class="data-value"><?= htmlspecialchars($student[$col]) ?></div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>

    </div>

</div>

<!-- أزرار الإجراءات -->
<div class="card-glass text-center mt-4">
<?php if ($student['status']=='pending'): ?>
    <a href="student_view.php?id=<?= $id ?>&verify=1" class="btn btn-success btn-action">✔ تم التدقيق</a>

<?php elseif ($student['status']=='verified'): ?>
    <a href="accept_student.php?id=<?= $id ?>" class="btn btn-primary btn-action">🎓 قبول الطالب + إنشاء الحساب</a>

<?php elseif ($student['status']=='accepted'): ?>
    <button class="btn btn-info btn-action disabled">✔ الطالب مقبول</button>
<?php endif; ?>
</div>

<!-- ==================== ملفات PDF المرفوعة ==================== -->

<h4 class="mt-4 mb-2">📄 ملفات PDF المرفوعة</h4>

<?php
$pdfs = $conn->prepare("SELECT * FROM student_pdf WHERE student_id=? ORDER BY id DESC");
$pdfs->execute([$id]);   // ← تم تصحيح الخطأ هنا
$pdf_list = $pdfs->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="card-glass p-3">

<?php if (empty($pdf_list)): ?>

    <div class="alert alert-info text-center mb-0">
        لا توجد ملفات PDF مرفوعة لهذا الطالب.
    </div>

<?php else: ?>

<table class="table table-dark table-striped text-center align-middle mb-0">
    <thead>
        <tr>
            <th>اسم الملف</th>
            <th>الحجم</th>
            <th>رفع بواسطة</th>
            <th>تاريخ الرفع</th>
            <th>خيارات</th>
        </tr>
    </thead>

    <tbody>
    <?php foreach ($pdf_list as $pdf): ?>
        <tr>
            <td><?= htmlspecialchars($pdf['pdf_name']) ?></td>
            <td><?= htmlspecialchars($pdf['file_size']) ?></td>
            <td><?= htmlspecialchars($pdf['uploaded_by']) ?></td>
            <td><?= htmlspecialchars($pdf['created_at']) ?></td>

            <td>
                <a href="../<?= $pdf['pdf_path'] ?>" 
                   target="_blank" 
                   class="btn btn-info btn-sm"><i class="bi bi-eye-fill"></i> عرض</a>

                <a href="download_pdf.php?id=<?= $pdf['id'] ?>" 
                   class="btn btn-success btn-sm"><i class="bi bi-download"></i> تحميل</a>

                <a href="delete_pdf.php?id=<?= $pdf['id'] ?>&sid=<?= $id ?>"
                   onclick="return confirm('هل تريد حذف هذا الملف؟');"
                   class="btn btn-danger btn-sm">
                    <i class="bi bi-trash-fill"></i> حذف
                </a>
            </td>
        </tr>
    <?php endforeach; ?>
    </tbody>
</table>

<?php endif; ?>
</div>

</div>
</body>
</html>