<?php
session_start();
require_once "../config/db.php";
require_once "../config/app.php";
require_once "../config/security.php";

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit;
}

// فلترة
$where = "";
$status_filter = "";
$search = "";

if (isset($_GET['status']) && $_GET['status'] !== "") {
    $status_filter = sanitize($_GET['status']);
    $where = "WHERE status='$status_filter'";
}

if (isset($_GET['search']) && $_GET['search'] !== "") {
    $search = sanitize($_GET['search']);
    $where = "WHERE full_name LIKE '%$search%' OR exam_number LIKE '%$search%'";
}

// جلب الطلاب
$students = $conn->query("
    SELECT id, full_name, exam_number, college_name, college_fee, study_type, status, created_at 
    FROM students 
    $where 
    ORDER BY id DESC
")->fetchAll(PDO::FETCH_ASSOC);

// عنوان الصفحة
$page_title = "قائمة الطلاب";
require_once "includes/header.php";
require_once "includes/navbar.php";
?>

<style>
/* نفس التصميم بدون تغيير */
body {
    background: radial-gradient(circle at top,#0f172a,#1e1b4b);
    color:white;
    font-family:"Tajawal";
}

.navbar-custom {
    background:linear-gradient(90deg,#1e293b,#4338ca);
    padding:14px 20px;
    display:flex;
    align-items:center;
}

.navbar-custom img {
    width:50px;
    height:50px;
    border-radius:12px;
    background:#fff;
}

.navbar-custom .title {
    font-size:22px;
    font-weight:700;
    margin-right:15px;
}

.container-custom {
    max-width:1350px;
    margin:25px auto;
}

.glass-card {
    background:rgba(255,255,255,0.07);
    border-radius:16px;
    border:1px solid rgba(255,255,255,0.15);
    padding:20px;
    box-shadow:0 12px 35px rgba(0,0,0,0.38);
}

.table {
    color:white;
    font-size:14px;
}

.table thead {
    background:rgba(255,255,255,0.14);
}

.table tbody tr:nth-child(even) {
    background:rgba(255,255,255,0.07);
}

.badge-status {
    padding:5px 10px;
    border-radius:10px;
    font-size:12px;
    cursor:pointer;
}

.bg-pending { background:rgba(234,179,8,0.3); color:#facc15; }
.bg-verified { background:rgba(59,130,246,0.3); color:#93c5fd; }
.bg-accepted { background:rgba(16,185,129,0.3); color:#6ee7b7; }

.btn-main {
    background:linear-gradient(90deg,#3b82f6,#6366f1);
    border:0;
    padding:8px 14px;
    border-radius:10px;
    color:#fff;
    font-size:13px;
}
</style>

<div class="page-content">

<div class="container-custom">
<div class="glass-card">

<!-- فلترة + بحث -->
<form method="GET" class="row g-3 mb-3">
    <div class="col-md-3">
        <select name="status" class="form-control">
            <option value="">كل الحالات</option>
            <option value="pending" <?= $status_filter=="pending"?"selected":"" ?>>غير مدقق</option>
            <option value="verified" <?= $status_filter=="verified"?"selected":"" ?>>مدقق</option>
            <option value="accepted" <?= $status_filter=="accepted"?"selected":"" ?>>مقبول</option>
        </select>
    </div>

    <div class="col-md-6">
        <input type="text" name="search" class="form-control" placeholder="بحث..." value="<?= $search ?>">
    </div>

    <div class="col-md-3">
        <button class="btn btn-main w-100">بحث</button>
    </div>
</form>

<!-- جدول الطلاب -->
<div class="table-responsive mt-4">
<table class="table table-bordered text-center">
<thead>
<tr>
    <th>الاسم</th>
    <th>الرقم الامتحاني</th>
    <th>القسم</th>
    <th>القسط</th>
    <th>الحالة</th>
    <th>التقديم</th>
    <th>إجراءات</th>
</tr>
</thead>

<tbody>
<?php if (count($students) == 0): ?>
    <tr><td colspan="7">لا توجد بيانات</td></tr>
<?php endif; ?>

<?php foreach ($students as $st): ?>
<tr>
    <td><?= htmlspecialchars($st['full_name']) ?></td>
    <td><?= htmlspecialchars($st['exam_number']) ?></td>
    <td><?= htmlspecialchars($st['college_name']) ?></td>
    <td><?= number_format($st['college_fee']) ?> د.ع</td>

    <td>
        <a href="student_view.php?id=<?= $st['id'] ?>">
        <?php if ($st['status']=="pending"): ?>
            <span class="badge-status bg-pending">غير مدقق</span>
        <?php elseif ($st['status']=="verified"): ?>
            <span class="badge-status bg-verified">مدقق</span>
        <?php else: ?>
            <span class="badge-status bg-accepted">مقبول</span>
        <?php endif; ?>
        </a>
    </td>

    <td><?= $st['created_at'] ?></td>

    <td>
        <a href="student_view.php?id=<?= $st['id'] ?>" class="btn btn-main btn-sm">عرض</a>
        <a href="student_edit.php?id=<?= $st['id'] ?>" class="btn btn-warning btn-sm">تعديل</a>
        <a onclick="return confirm('حذف؟');" href="student_delete.php?id=<?= $st['id'] ?>" class="btn btn-danger btn-sm">حذف</a>
    </td>
</tr>
<?php endforeach; ?>
</tbody>

</table>
</div>

</div>
</div>

</div>

<?php require_once "includes/footer.php"; ?>