<?php
session_start();
require_once "../config/db.php";
require_once "../config/security.php";
require_once "../config/app.php";

// حماية الادمن
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit;
}

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("❌ خطأ: الطالب غير موجود.");
}

$student_id = intval($_GET['id']);

// جلب اسم الطالب
$stmt = $conn->prepare("SELECT full_name FROM students WHERE id=? LIMIT 1");
$stmt->execute([$student_id]);
$student = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$student) die("❌ الطالب غير موجود.");

// رسائل النظام
$success = "";
$error = "";

// عند رفع الملف
if ($_SERVER["REQUEST_METHOD"] === "POST") {

    if (!isset($_FILES["pdf"]) || $_FILES["pdf"]["error"] !== 0) {
        $error = "❌ يرجى اختيار ملف PDF صالح.";
    } else {

        $ext = strtolower(pathinfo($_FILES["pdf"]["name"], PATHINFO_EXTENSION));
        if ($ext !== "pdf") {
            $error = "❌ فقط ملفات PDF مسموح بها.";
        } else {

            // مجلد الطالب
            $dir = "../uploads/pdfs/$student_id/";
            if (!is_dir($dir)) {
                mkdir($dir, 0777, true);
                chmod($dir, 0777);
            }

            // اسم ملف نظيف
            $safeName = preg_replace('/[^A-Za-z0-9_\-]/', '_', $student['full_name']);

            // اسم نهائي للملف
            $file_name = $safeName . "_" . time() . ".pdf";

            // حجم الملف
            $file_size = round($_FILES["pdf"]["size"] / 1024, 2) . " KB";

            // رفع الملف
            move_uploaded_file($_FILES["pdf"]["tmp_name"], $dir . $file_name);

            // مسار كامل للتخزين في قاعدة البيانات
            $full_path = "uploads/pdfs/$student_id/$file_name";

            // حفظ السجل بالقاعدة (لا حذف – إضافة فقط)
            $insert = $conn->prepare("
                INSERT INTO student_pdf (student_id, pdf_path, pdf_name, file_size, uploaded_by, uploaded_ip)
                VALUES (?,?,?,?,?,?)
            ");
            $insert->execute([
                $student_id,
                $full_path,
                $file_name,
                $file_size,
                $_SESSION['admin_logged_in'],
                $_SERVER['REMOTE_ADDR']
            ]);

            $success = "✔ تم رفع ملف PDF جديد للطالب بدون حذف الملفات السابقة!";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>رفع PDF - نسخة 2030</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body {
    background: #0f172a;
    color: white;
    font-family: "Tajawal";
}

.box {
    max-width: 650px;
    margin: 40px auto;
    padding: 40px;
    background: rgba(255,255,255,0.06);
    border-radius: 22px;
    border: 1px solid rgba(255,255,255,0.2);
    backdrop-filter: blur(10px);
}
</style>

</head>
<body>

<div class="box">
    <h3 class="text-center mb-4">📄 رفع ملف PDF للطالب</h3>
    <h5 class="text-center mb-3"><?= htmlspecialchars($student['full_name']) ?></h5>

    <?php if ($success): ?>
        <div class="alert alert-success"><?= $success ?></div>
    <?php endif; ?>

    <?php if ($error): ?>
        <div class="alert alert-danger"><?= $error ?></div>
    <?php endif; ?>

    <form method="POST" enctype="multipart/form-data">
        <label class="form-label">اختر ملف PDF</label>
        <input type="file" name="pdf" class="form-control mb-3" required>

        <button class="btn btn-primary w-100">رفع الملف</button>
    </form>

    <div class="text-center mt-4">
        <a href="student_view.php?id=<?= $student_id ?>" class="btn btn-secondary btn-sm">عودة</a>
    </div>
</div>

</body>
</html>