<?php
session_start();
require_once "../config/db.php";

// السماح فقط للمدير
// if ($_SESSION['role'] != "accounts") die("غير مصرح");

$instance_id = "instance153433";
$token = "zuakd3jkp0v55yej";

// ---------------------------
// 1) حفظ التعديلات
// ---------------------------
if (isset($_POST['save_template'])) {

    foreach ($_POST['template'] as $key => $value) {
        $stmt = $conn->prepare("
            INSERT INTO whatsapp_templates (template_key, template_text)
            VALUES (?, ?)
            ON DUPLICATE KEY UPDATE template_text=VALUES(template_text)
        ");
        $stmt->execute([$key, $value]);
    }

    $saved = true;
}

// ---------------------------
// 2) جلب القوالب
// ---------------------------
$templates = [];
$q = $conn->query("SELECT * FROM whatsapp_templates");
while ($row = $q->fetch(PDO::FETCH_ASSOC)) {
    $templates[$row['template_key']] = $row['template_text'];
}

function tpl($key, $default="") {
    global $templates;
    return $templates[$key] ?? $default;
}

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>إعدادات رسائل واتساب</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
</head>
<body class="bg-dark text-white">

<div class="container mt-5">

<h2 class="text-info mb-4"><i class="bi bi-whatsapp"></i> إعدادات رسائل واتساب</h2>

<?php if (!empty($saved)): ?>
<div class="alert alert-success text-center fw-bold">✔ تم حفظ التعديلات بنجاح</div>
<?php endif; ?>

<form method="POST">

    <div class="mb-4">
        <label class="form-label text-warning">رسالة إضافة قسط جديد</label>
        <textarea name="template[payment_added]" class="form-control" rows="4"><?= tpl("payment_added", 
"📢 *إشعار دفعة جديدة*
👤 الطالب: {student_name}
💵 الدفعة: {amount} د.ع
💰 مجموع المدفوع: {paid}
💸 المتبقي: {remaining}
🧾 رقم الوصل: {receipt}
📅 التاريخ: {date}") ?></textarea>
    </div>

    <div class="mb-4">
        <label class="form-label text-warning">رسالة تغيير المرحلة</label>
        <textarea name="template[level_changed]" class="form-control" rows="4"><?= tpl("level_changed",
"📢 *تم تغيير المرحلة*
👤 الطالب: {student_name}
📘 المرحلة الجديدة: {level}
💰 القسط الجديد: {fee} د.ع
📅 التاريخ: {date}") ?></textarea>
    </div>

    <div class="mb-4">
        <label class="form-label text-warning">رسالة تجريبية</label>
        <textarea name="template[test_message]" class="form-control" rows="4"><?= tpl("test_message",
"🔔 *رسالة تجريبية من نظام الحسابات*
هذا مثال لرسالة تظهر للمدير قبل اعتمادها.") ?></textarea>
    </div>

    <button name="save_template" class="btn btn-primary w-100 mb-4">
        <i class="bi bi-save"></i> حفظ التعديلات
    </button>

</form>

<!-- زر الرسالة التجريبية -->
<form method="POST">
    <h4 class="text-info">إرسال رسالة تجريبية</h4>

    <div class="row mt-2">
        <div class="col-md-6 mb-3">
            <label>رقم الهاتف (تجريبي)</label>
            <input name="test_phone" class="form-control" placeholder="0770xxxxxxx" required>
        </div>

        <div class="col-md-6 mb-3">
            <label>نص الرسالة</label>
            <input name="test_message" class="form-control" value="رسالة تجريبية" required>
        </div>
    </div>

    <button name="send_test" class="btn btn-success w-100">
        <i class="bi bi-send"></i> إرسال رسالة تجريبية
    </button>
</form>

<?php
// ---------------------------
// إرسال الرسالة التجريبية
// ---------------------------
if (isset($_POST['send_test'])) {

    $phone = str_replace(" ", "", $_POST['test_phone']);
    $msg   = $_POST['test_message'];

    $url = "https://api.ultramsg.com/$instance_id/messages/chat";

    $postData = [
        "token" => $token,
        "to"    => $phone,
        "body"  => $msg
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    curl_close($ch);

    echo "<div class='alert alert-info mt-4'>نتيجة الإرسال: <br><pre>$result</pre></div>";
}
?>

</div>

</body>
</html>