<?php

require_once __DIR__ . "/../vendor/autoload.php";

putenv('GOOGLE_APPLICATION_CREDENTIALS=google_credentials.json');

function uploadToDrive($file_path, $file_name){

    $client = new Google_Client();
    $client->useApplicationDefaultCredentials();
    $client->setScopes(Google_Service_Drive::DRIVE);

    $service = new Google_Service_Drive($client);

    $file = new Google_Service_Drive_DriveFile();
    $file->setName($file_name);

    $folderId = "YOUR_GOOGLE_DRIVE_FOLDER_ID"; // ضع مجلد النسخ

    if ($folderId != "") {
        $file->setParents(array($folderId));
    }

    $content = file_get_contents($file_path);

    $uploadedFile = $service->files->create($file, [
        'data' => $content,
        'uploadType' => 'multipart',
        'fields' => 'id'
    ]);

    return $uploadedFile->id;
}

?>
