<?php
// core/AdminController.php

require_once __DIR__ . '/../config/db.php';

class AdminController {

    public static function create($name, $username, $password, $role = 'registration', $phone = null) {
        global $conn;

        $hash = password_hash($password, PASSWORD_BCRYPT);

        $stmt = $conn->prepare("INSERT INTO admins (name,username,password,role,phone) VALUES (?,?,?,?,?)");
        return $stmt->execute([$name, $username, $hash, $role, $phone]);
    }

    public static function getByUsername($username) {
        global $conn;
        $stmt = $conn->prepare("SELECT * FROM admins WHERE username=?");
        $stmt->execute([$username]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public static function getById($id) {
        global $conn;
        $stmt = $conn->prepare("SELECT * FROM admins WHERE id=?");
        $stmt->execute([$id]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public static function listAll() {
        global $conn;
        $stmt = $conn->prepare("SELECT * FROM admins ORDER BY id ASC");
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
