<?php
// core/BackupController.php

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../config/google_drive.php';
require_once __DIR__ . '/../config/backup_settings.php';

class BackupController {

    public static function runDailyBackup() {
        global $backup_folder;

        if (!is_dir($backup_folder)) {
            mkdir($backup_folder, 0777, true);
        }

        $date = date('Y-m-d_H-i');
        $sql_file = $backup_folder . "db_backup_{$date}.sql";
        $zip_file = $backup_folder . "backup_{$date}.zip";

        // 1) تصدير قاعدة البيانات (يتطلب mysqldump منصب)
        $db_host = "localhost";
        $db_user = "root";
        $db_pass = "";
        $db_name = "nebres_university";

        $cmd = "mysqldump -h {$db_host} -u {$db_user} ".($db_pass ? "-p{$db_pass} " : "")." {$db_name} > {$sql_file}";
        shell_exec($cmd);

        // 2) ضغط sql + مجلد uploads
        $zip = new ZipArchive();
        if ($zip->open($zip_file, ZipArchive::CREATE) === true) {
            $zip->addFile($sql_file, basename($sql_file));

            self::folderToZip(__DIR__ . '/../uploads', $zip, 'uploads');

            $zip->close();
        }

        // 3) رفع إلى Google Drive
        $drive_id = uploadToDrive($zip_file, basename($zip_file));

        // 4) حفظ في backup_logs
        global $conn;
        $size = filesize($zip_file);
        $stmt = $conn->prepare("INSERT INTO backup_logs (file_name,file_size,drive_url) VALUES (?,?,?)");
        $stmt->execute([basename($zip_file), $size, $drive_id]);

        // 5) حذف sql المحلي (اختياري)
        @unlink($sql_file);

        return true;
    }

    private static function folderToZip($folder, & $zipFile, $subfolder = '') {
        $handle = opendir($folder);
        while (false !== ($f = readdir($handle))) {
            if ($f != '.' && $f != '..') {
                $filePath = "$folder/$f";
                $localPath = $subfolder ? "$subfolder/$f" : $f;

                if (is_file($filePath)) {
                    $zipFile->addFile($filePath, $localPath);
                } else if (is_dir($filePath)) {
                    self::folderToZip($filePath, $zipFile, $localPath);
                }
            }
        }
        closedir($handle);
    }
}
