<?php
// core/FieldController.php

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../config/migration.php';

class FieldController {

    public static function getAll() {
        global $conn;
        $stmt = $conn->prepare("SELECT * FROM fields ORDER BY order_number ASC");
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public static function getById($id) {
        global $conn;
        $stmt = $conn->prepare("SELECT * FROM fields WHERE id=?");
        $stmt->execute([$id]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public static function create($data) {
        global $conn;

        // إضافة عمود للطلاب
        if (!empty($data['field_name']) && !empty($data['sql_type'])) {
            addColumnIfNotExists('students', $data['field_name'], $data['sql_type']);
        }

        $stmt = $conn->prepare("INSERT INTO fields 
            (field_name, field_label, field_type, is_required, show_in_pdf, show_in_dashboard, order_number, options)
            VALUES (?,?,?,?,?,?,?,?)");

        $options = isset($data['options']) ? json_encode($data['options'], JSON_UNESCAPED_UNICODE) : null;

        return $stmt->execute([
            $data['field_name'],
            $data['field_label'],
            $data['field_type'],
            !empty($data['is_required']) ? 1 : 0,
            !empty($data['show_in_pdf']) ? 1 : 0,
            !empty($data['show_in_dashboard']) ? 1 : 0,
            (int)$data['order_number'],
            $options
        ]);
    }

    public static function update($id, $data) {
        global $conn;

        $field = self::getById($id);
        if (!$field) return false;

        // لو تغير اسم الحقل أو نوعه في SQL
        if (!empty($data['field_name']) && !empty($data['sql_type']) && $data['field_name'] != $field['field_name']) {
            addColumnIfNotExists('students', $data['field_name'], $data['sql_type']);
            // ملاحظة: بإمكانك لاحقاً نقل البيانات من العمود القديم للجديد
        }

        $stmt = $conn->prepare("UPDATE fields SET 
            field_name=?, field_label=?, field_type=?, is_required=?, show_in_pdf=?, show_in_dashboard=?, order_number=?, options=?
            WHERE id=?");

        $options = isset($data['options']) ? json_encode($data['options'], JSON_UNESCAPED_UNICODE) : null;

        return $stmt->execute([
            $data['field_name'],
            $data['field_label'],
            $data['field_type'],
            !empty($data['is_required']) ? 1 : 0,
            !empty($data['show_in_pdf']) ? 1 : 0,
            !empty($data['show_in_dashboard']) ? 1 : 0,
            (int)$data['order_number'],
            $options,
            $id
        ]);
    }

    public static function delete($id) {
        global $conn;
        $field = self::getById($id);
        if (!$field) return false;

        // حذف العمود من جدول الطلاب
        removeColumnIfExists('students', $field['field_name']);

        $stmt = $conn->prepare("DELETE FROM fields WHERE id=?");
        return $stmt->execute([$id]);
    }
}
