<?php
// core/Logger.php – النسخة المطوّرة B2Pro

require_once __DIR__ . '/../config/db.php';

class Logger {

    /**
     * تسجيل عملية في جدول logs
     *
     * @param int|null $admin_id     (ID الموظف)
     * @param int|null $student_id   (ID الطالب)
     * @param string   $action       نوع العملية
     * @param string   $details      تفاصيل إضافية
     */
    public static function log($admin_id = null, $student_id = null, $action = "UNKNOWN", $details = "") {
        global $conn;

        try {

            // تنظيف النص لتفادي مشاكل الإدراج
            $details = self::safeText($details);

            // بيانات إضافية
            $ip = $_SERVER['REMOTE_ADDR'] ?? 'UNKNOWN';
            $agent = $_SERVER['HTTP_USER_AGENT'] ?? 'UNKNOWN';

            // سجل كامل
            $stmt = $conn->prepare("
                INSERT INTO logs 
                (admin_id, student_id, action, details, ip_address, user_agent, created_at) 
                VALUES (?, ?, ?, ?, ?, ?, NOW())
            ");

            $stmt->execute([
                $admin_id,
                $student_id,
                $action,
                $details,
                $ip,
                $agent
            ]);

        } catch (Exception $e) {
            // في حال فشل السجل — نكتب سجل طوارئ في ملف مؤقت
            file_put_contents(
                __DIR__ . '/../logs_error.txt',
                date("Y-m-d H:i:s") . " | LOG ERROR | " . $e->getMessage() . PHP_EOL,
                FILE_APPEND
            );
        }
    }

    /**
     * تنظيف النص قبل إدخاله للقاعدة
     */
    private static function safeText($text) {
        // إزالة الرموز التي تسبب مشاكل
        $text = trim($text);
        $text = str_replace(["\r", "\n", "\t"], " ", $text);
        return $text;
    }
}