-- MariaDB dump 10.19  Distrib 10.4.28-MariaDB, for osx10.10 (x86_64)
--
-- Host: localhost    Database: nebres_university
-- ------------------------------------------------------
-- Server version	10.4.28-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `account_installments`
--

DROP TABLE IF EXISTS `account_installments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_installments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `installment_number` int(11) NOT NULL,
  `amount` int(11) NOT NULL,
  `due_date` date NOT NULL,
  `paid_amount` int(11) DEFAULT 0,
  `paid_date` datetime DEFAULT NULL,
  `status` enum('pending','partial','paid','late') DEFAULT 'pending',
  `notes` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  KEY `account_id` (`account_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `account_installments`
--

LOCK TABLES `account_installments` WRITE;
/*!40000 ALTER TABLE `account_installments` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_installments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `account_years`
--

DROP TABLE IF EXISTS `account_years`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_years` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `level` enum('المرحلة الأولى','المرحلة الثانية','المرحلة الثالثة','المرحلة الرابعة','المرحلة الخامسة') NOT NULL,
  `total_fee` int(11) NOT NULL DEFAULT 0,
  `paid` int(11) NOT NULL DEFAULT 0,
  `remaining` int(11) NOT NULL DEFAULT 0,
  `payment_plan` varchar(50) DEFAULT 'دفعة واحدة',
  `year_label` varchar(20) DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `fk_std_acc` (`student_id`),
  CONSTRAINT `fk_std_acc` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `account_years`
--

LOCK TABLES `account_years` WRITE;
/*!40000 ALTER TABLE `account_years` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_years` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `total_fee` int(11) NOT NULL DEFAULT 0,
  `discount` int(11) NOT NULL DEFAULT 0,
  `paid` int(11) NOT NULL DEFAULT 0,
  `remaining` int(11) NOT NULL DEFAULT 0,
  `level` enum('المرحلة الأولى','المرحلة الثانية','المرحلة الثالثة','المرحلة الرابعة','المرحلة الخامسة') NOT NULL DEFAULT 'المرحلة الأولى',
  `payment_plan` enum('دفعة واحدة','دفعتين','3 دفعات','4 دفعات','5 دفعات','6 دفعات') NOT NULL DEFAULT 'دفعة واحدة',
  `installments` int(11) NOT NULL DEFAULT 1,
  `amount_per_installment` int(11) NOT NULL DEFAULT 0,
  `year` int(11) NOT NULL DEFAULT year(curdate()),
  `installment1` int(11) DEFAULT 0,
  `installment2` int(11) DEFAULT 0,
  `installment3` int(11) DEFAULT 0,
  `installment4` int(11) DEFAULT 0,
  `installment5` int(11) DEFAULT 0,
  `installment6` int(11) DEFAULT 0,
  `due_date` date DEFAULT NULL,
  `last_update` datetime DEFAULT current_timestamp(),
  `status` enum('normal','warning','late','critical','frozen') DEFAULT 'normal',
  `last_overdue` int(11) DEFAULT 0,
  `collection_status` enum('none','in_progress','promise_to_pay','no_response','refused','legal') DEFAULT 'none',
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  CONSTRAINT `acc_student_fk` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=72 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (71,47,1900000,0,1350000,550000,'المرحلة الثالثة','دفعتين',1,0,2025,0,0,0,0,0,0,'2025-12-01','2025-12-02 13:46:16','normal',0,'none');
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admins`
--

DROP TABLE IF EXISTS `admins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `username` varchar(150) NOT NULL,
  `password` varchar(255) NOT NULL,
  `role` enum('admin','registration','accounts','president') NOT NULL DEFAULT 'registration',
  `phone` varchar(50) DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admins`
--

LOCK TABLES `admins` WRITE;
/*!40000 ALTER TABLE `admins` DISABLE KEYS */;
INSERT INTO `admins` VALUES (1,'مدير التسجيل','admin','$2y$10$IUefco7XTOiWfZ6DcGrRZO9Q.dcPGjrPb3d5hBvShjXluTes5nHXq','registration',NULL,'2025-11-27 14:30:57');
/*!40000 ALTER TABLE `admins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ai_fraud_logs`
--

DROP TABLE IF EXISTS `ai_fraud_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ai_fraud_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_id` int(11) DEFAULT NULL,
  `student_id` int(11) NOT NULL,
  `risk_score` int(11) NOT NULL,
  `risk_level` enum('LOW','MEDIUM','HIGH','CRITICAL') NOT NULL,
  `reason` text DEFAULT NULL,
  `detected_at` datetime DEFAULT current_timestamp(),
  `status` enum('clean','under_review','blocked') DEFAULT 'under_review',
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  KEY `payment_id` (`payment_id`),
  CONSTRAINT `ai_fraud_logs_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ai_fraud_logs_ibfk_2` FOREIGN KEY (`payment_id`) REFERENCES `payments` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ai_fraud_logs`
--

LOCK TABLES `ai_fraud_logs` WRITE;
/*!40000 ALTER TABLE `ai_fraud_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `ai_fraud_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `appearance_settings`
--

DROP TABLE IF EXISTS `appearance_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `appearance_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key_name` varchar(190) DEFAULT NULL,
  `key_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key_name` (`key_name`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `appearance_settings`
--

LOCK TABLES `appearance_settings` WRITE;
/*!40000 ALTER TABLE `appearance_settings` DISABLE KEYS */;
INSERT INTO `appearance_settings` VALUES (1,'mode','dark'),(2,'primary_color','#6366f1'),(3,'secondary_color','#3b82f6'),(4,'bg_color','#0f172a'),(5,'bg_opacity','0.12'),(6,'glass_blur','12'),(7,'font_family','Noto Kufi Arabic');
/*!40000 ALTER TABLE `appearance_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_log`
--

DROP TABLE IF EXISTS `audit_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `audit_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_name` varchar(150) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `details` text DEFAULT NULL,
  `ip_address` varchar(50) DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_log`
--

LOCK TABLES `audit_log` WRITE;
/*!40000 ALTER TABLE `audit_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_logs`
--

DROP TABLE IF EXISTS `backup_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `backup_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_name` varchar(255) DEFAULT NULL,
  `file_size` varchar(100) DEFAULT NULL,
  `drive_url` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_logs`
--

LOCK TABLES `backup_logs` WRITE;
/*!40000 ALTER TABLE `backup_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_settings`
--

DROP TABLE IF EXISTS `backup_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `backup_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key_name` varchar(190) DEFAULT NULL,
  `key_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key_name` (`key_name`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_settings`
--

LOCK TABLES `backup_settings` WRITE;
/*!40000 ALTER TABLE `backup_settings` DISABLE KEYS */;
INSERT INTO `backup_settings` VALUES (1,'telegram_token','8368258032:AAG3iTCvbxTJFZtxsgY0CwShjqh1lebIsFc'),(2,'telegram_chat_id','@azbadr11hash'),(3,'drive_api_key',''),(4,'drive_folder_id',''),(5,'external_backup_url',''),(6,'auto_telegram','on'),(7,'auto_drive','on'),(8,'auto_server','no'),(17,'auto_backup','on'),(20,'auto_external','on'),(29,'drive_api',''),(30,'external_url','');
/*!40000 ALTER TABLE `backup_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `builder_settings`
--

DROP TABLE IF EXISTS `builder_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `builder_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key_name` varchar(190) DEFAULT NULL,
  `key_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key_name` (`key_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `builder_settings`
--

LOCK TABLES `builder_settings` WRITE;
/*!40000 ALTER TABLE `builder_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `builder_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `channels`
--

DROP TABLE IF EXISTS `channels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `channels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `channel_name` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `channels`
--

LOCK TABLES `channels` WRITE;
/*!40000 ALTER TABLE `channels` DISABLE KEYS */;
INSERT INTO `channels` VALUES (3,'الشهداء','2025-11-30 03:14:22');
/*!40000 ALTER TABLE `channels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `collection_agents`
--

DROP TABLE IF EXISTS `collection_agents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `collection_agents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `username` varchar(150) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `collection_agents`
--

LOCK TABLES `collection_agents` WRITE;
/*!40000 ALTER TABLE `collection_agents` DISABLE KEYS */;
/*!40000 ALTER TABLE `collection_agents` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `collection_followup`
--

DROP TABLE IF EXISTS `collection_followup`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `collection_followup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `agent_id` int(11) DEFAULT NULL,
  `contact_type` enum('phone','whatsapp','visit','email') DEFAULT 'phone',
  `status` enum('pending','responded','promise','no_answer','refused') DEFAULT 'pending',
  `notes` text DEFAULT NULL,
  `next_follow` date DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  KEY `agent_id` (`agent_id`),
  CONSTRAINT `collection_followup_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `collection_followup_ibfk_2` FOREIGN KEY (`agent_id`) REFERENCES `collection_agents` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `collection_followup`
--

LOCK TABLES `collection_followup` WRITE;
/*!40000 ALTER TABLE `collection_followup` DISABLE KEYS */;
/*!40000 ALTER TABLE `collection_followup` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `colleges`
--

DROP TABLE IF EXISTS `colleges`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `colleges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `university_name` varchar(255) DEFAULT NULL,
  `college_name` varchar(255) NOT NULL,
  `study_type` enum('صباحي','مسائي') DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  `fee` int(11) NOT NULL DEFAULT 0,
  `years` int(11) NOT NULL DEFAULT 4,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `colleges`
--

LOCK TABLES `colleges` WRITE;
/*!40000 ALTER TABLE `colleges` DISABLE KEYS */;
INSERT INTO `colleges` VALUES (4,'جامعة النبراس','هندسة الحاسبات','صباحي','2025-11-30 03:12:38',1900000,4);
/*!40000 ALTER TABLE `colleges` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `documents`
--

DROP TABLE IF EXISTS `documents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `documents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `file_path` varchar(255) NOT NULL,
  `file_type` varchar(100) DEFAULT NULL,
  `uploaded_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  CONSTRAINT `documents_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `documents`
--

LOCK TABLES `documents` WRITE;
/*!40000 ALTER TABLE `documents` DISABLE KEYS */;
/*!40000 ALTER TABLE `documents` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `due_date_logs`
--

DROP TABLE IF EXISTS `due_date_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `due_date_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `schedule_id` int(11) NOT NULL,
  `old_due_date` date NOT NULL,
  `new_due_date` date NOT NULL,
  `reason` text NOT NULL,
  `changed_by` int(11) NOT NULL,
  `changed_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `due_date_logs`
--

LOCK TABLES `due_date_logs` WRITE;
/*!40000 ALTER TABLE `due_date_logs` DISABLE KEYS */;
INSERT INTO `due_date_logs` VALUES (1,18,'2025-12-03','2025-12-03','hungry',1,'2025-12-02 13:11:20'),(2,18,'2025-12-03','2025-12-09','ggfdhhe',1,'2025-12-02 13:11:45'),(3,18,'2025-12-09','2025-12-26','ghdttgfghyfu',1,'2025-12-02 13:16:34'),(4,19,'2026-01-02','2025-12-16','bfgbdrhrhtjhrty',3,'2025-12-02 13:34:18');
/*!40000 ALTER TABLE `due_date_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fields`
--

DROP TABLE IF EXISTS `fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_name` varchar(200) NOT NULL,
  `field_label` varchar(255) NOT NULL,
  `field_type` enum('text','number','date','time','textarea','file','radio','checkbox','select','calculated','hidden') NOT NULL,
  `is_required` tinyint(1) DEFAULT 0,
  `show_in_pdf` tinyint(1) DEFAULT 1,
  `show_in_dashboard` tinyint(1) DEFAULT 1,
  `order_number` int(11) DEFAULT 0,
  `options` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  `section_name` varchar(150) DEFAULT 'personal',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fields`
--

LOCK TABLES `fields` WRITE;
/*!40000 ALTER TABLE `fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `finance_users`
--

DROP TABLE IF EXISTS `finance_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `finance_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `username` varchar(150) NOT NULL,
  `password` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  `last_login` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `finance_users`
--

LOCK TABLES `finance_users` WRITE;
/*!40000 ALTER TABLE `finance_users` DISABLE KEYS */;
INSERT INTO `finance_users` VALUES (1,'مدير الحسابات','az','$2y$10$vRl.OoiorlpYkxxB1zcqFOxzZBuiVXVNVbLpoaucewdqmIUys5526','2025-11-29 22:03:38',NULL),(3,'بارق عبدالله احمد','bar','$2y$10$dtGtL2j9wIjNxfCkrgKjd.9whjuMvZkOz41uLPRXvpyfzFOL.fQQe','2025-12-02 13:20:47',NULL);
/*!40000 ALTER TABLE `finance_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `installment_due_dates`
--

DROP TABLE IF EXISTS `installment_due_dates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `installment_due_dates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `installment_number` int(11) NOT NULL,
  `amount` int(11) NOT NULL,
  `due_date` date DEFAULT NULL,
  `status` enum('paid','pending','late') DEFAULT 'pending',
  `updated_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  CONSTRAINT `installment_due_dates_ibfk_1` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `installment_due_dates`
--

LOCK TABLES `installment_due_dates` WRITE;
/*!40000 ALTER TABLE `installment_due_dates` DISABLE KEYS */;
/*!40000 ALTER TABLE `installment_due_dates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `installment_plan`
--

DROP TABLE IF EXISTS `installment_plan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `installment_plan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `year_level` varchar(100) NOT NULL,
  `total_fee` bigint(20) NOT NULL,
  `installments_count` int(11) NOT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  CONSTRAINT `installment_plan_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `installment_plan`
--

LOCK TABLES `installment_plan` WRITE;
/*!40000 ALTER TABLE `installment_plan` DISABLE KEYS */;
/*!40000 ALTER TABLE `installment_plan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `installment_schedule`
--

DROP TABLE IF EXISTS `installment_schedule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `installment_schedule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `installment_number` int(11) NOT NULL,
  `amount` int(11) NOT NULL,
  `due_date` date NOT NULL,
  `paid_amount` int(11) DEFAULT 0,
  `paid_date` datetime DEFAULT NULL,
  `status` enum('pending','partial','paid','late') DEFAULT 'pending',
  `notes` text DEFAULT NULL,
  `penalty_amount` int(11) NOT NULL DEFAULT 0,
  `overdue_days` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  CONSTRAINT `installment_schedule_ibfk_1` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `installment_schedule`
--

LOCK TABLES `installment_schedule` WRITE;
/*!40000 ALTER TABLE `installment_schedule` DISABLE KEYS */;
INSERT INTO `installment_schedule` VALUES (18,71,1,950000,'2025-12-26',950000,'2025-12-02 12:46:24','pending',NULL,0,0,'2025-12-02 12:46:24','2025-12-02 13:16:34'),(19,71,2,950000,'2025-12-16',400000,'2025-12-02 13:46:16','partial',NULL,0,0,'2025-12-02 12:46:24','2025-12-02 13:46:16');
/*!40000 ALTER TABLE `installment_schedule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `installments`
--

DROP TABLE IF EXISTS `installments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `installments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `amount` bigint(20) NOT NULL,
  `due_date` date NOT NULL,
  `status` enum('pending','paid','late') DEFAULT 'pending',
  `paid_at` datetime DEFAULT NULL,
  `reminder_sent` tinyint(1) DEFAULT 0,
  `late_notice_sent` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `installments`
--

LOCK TABLES `installments` WRITE;
/*!40000 ALTER TABLE `installments` DISABLE KEYS */;
/*!40000 ALTER TABLE `installments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `installments_master`
--

DROP TABLE IF EXISTS `installments_master`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `installments_master` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `installment_number` int(11) NOT NULL,
  `amount` int(11) NOT NULL,
  `due_date` date NOT NULL,
  `paid_amount` int(11) DEFAULT 0,
  `status` enum('pending','partial','paid','late') DEFAULT 'pending',
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `installments_master`
--

LOCK TABLES `installments_master` WRITE;
/*!40000 ALTER TABLE `installments_master` DISABLE KEYS */;
/*!40000 ALTER TABLE `installments_master` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `logs`
--

DROP TABLE IF EXISTS `logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_id` int(11) DEFAULT NULL,
  `student_id` int(11) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `details` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `log_student_fk` (`student_id`),
  CONSTRAINT `log_student_fk` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `logs`
--

LOCK TABLES `logs` WRITE;
/*!40000 ALTER TABLE `logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notifications`
--

DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `message` text DEFAULT NULL,
  `status` enum('sent','failed') DEFAULT 'sent',
  `sent_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  CONSTRAINT `notif_student_fk` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notifications`
--

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `overdue_alerts`
--

DROP TABLE IF EXISTS `overdue_alerts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `overdue_alerts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `days_late` int(11) NOT NULL,
  `alert_level` enum('warning','late','critical') NOT NULL,
  `message` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  CONSTRAINT `overdue_alerts_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `overdue_alerts`
--

LOCK TABLES `overdue_alerts` WRITE;
/*!40000 ALTER TABLE `overdue_alerts` DISABLE KEYS */;
/*!40000 ALTER TABLE `overdue_alerts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `created_by` int(11) DEFAULT NULL,
  `finance_user_id` int(11) DEFAULT NULL,
  `account_id` int(11) NOT NULL,
  `amount` int(11) NOT NULL,
  `receipt_number` varchar(100) DEFAULT NULL,
  `receipt_image` varchar(255) DEFAULT NULL,
  `payment_type` enum('نقدي','حوالة','إلكتروني','منحة') DEFAULT 'نقدي',
  `notes` text DEFAULT NULL,
  `paid_at` datetime DEFAULT current_timestamp(),
  `account_year_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  KEY `pay_year_fk` (`account_year_id`),
  CONSTRAINT `pay_student_fk` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pay_year_fk` FOREIGN KEY (`account_year_id`) REFERENCES `account_years` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (24,47,NULL,NULL,71,95000000,'656565','receipt_692e33c525773.JPG','نقدي','','2025-12-02 03:33:09',NULL),(25,47,NULL,NULL,71,475000,'66556','receipt_692e3db710104.jpg','نقدي','','2025-12-02 04:15:35',NULL),(26,47,NULL,1,71,475000,'9988','receipt_692e534fa188e.jpg','نقدي','','2025-12-02 05:47:43',NULL),(27,47,NULL,1,71,950000,'88766','receipt_692eb360b7c7a.jpg','نقدي','','2025-12-02 12:37:36',NULL),(28,47,NULL,1,71,950000,'76655','receipt_692eb57004549.jpg','نقدي','','2025-12-02 12:46:24',NULL),(29,47,NULL,3,71,400000,'65665','receipt_692ec378da574.jpg','نقدي','','2025-12-02 13:46:16',NULL);
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pdf_settings`
--

DROP TABLE IF EXISTS `pdf_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pdf_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key_name` varchar(190) NOT NULL,
  `key_value` text DEFAULT NULL,
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `key_name` (`key_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pdf_settings`
--

LOCK TABLES `pdf_settings` WRITE;
/*!40000 ALTER TABLE `pdf_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `pdf_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reminder_jobs`
--

DROP TABLE IF EXISTS `reminder_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reminder_jobs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `installment_id` int(11) NOT NULL,
  `reminder_type` enum('72h','24h','12h','1h','late') NOT NULL,
  `sent` tinyint(1) DEFAULT 0,
  `sent_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `installment_id` (`installment_id`),
  CONSTRAINT `reminder_jobs_ibfk_1` FOREIGN KEY (`installment_id`) REFERENCES `installment_due_dates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reminder_jobs`
--

LOCK TABLES `reminder_jobs` WRITE;
/*!40000 ALTER TABLE `reminder_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `reminder_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(150) NOT NULL,
  `setting_value` text DEFAULT NULL,
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `setting_key` (`setting_key`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (1,'university_name','جامعة النبراس الاهلية','2025-12-03 15:25:03');
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `student_pdf`
--

DROP TABLE IF EXISTS `student_pdf`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `student_pdf` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `pdf_path` varchar(255) NOT NULL,
  `pdf_name` varchar(255) NOT NULL,
  `file_size` varchar(50) DEFAULT NULL,
  `uploaded_by` varchar(150) DEFAULT NULL,
  `uploaded_ip` varchar(50) DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  CONSTRAINT `student_pdf_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `student_pdf`
--

LOCK TABLES `student_pdf` WRITE;
/*!40000 ALTER TABLE `student_pdf` DISABLE KEYS */;
INSERT INTO `student_pdf` VALUES (2,47,'uploads/pdfs/47/gbhtbe_1764723153.pdf','gbhtbe_1764723153.pdf','95.48 KB','1','::1','2025-12-03 03:52:33'),(3,47,'uploads/pdfs/47/gbhtbe_1764724255.pdf','gbhtbe_1764724255.pdf','38016.33 KB','1','::1','2025-12-03 04:10:55'),(4,47,'uploads/pdfs/47/gbhtbe_1764728255.pdf','gbhtbe_1764728255.pdf','38016.33 KB','1','::1','2025-12-03 05:17:35');
/*!40000 ALTER TABLE `student_pdf` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `student_support`
--

DROP TABLE IF EXISTS `student_support`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `student_support` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `message` text NOT NULL,
  `reply` text DEFAULT NULL,
  `status` enum('pending','answered') DEFAULT 'pending',
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  CONSTRAINT `student_support_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `student_support`
--

LOCK TABLES `student_support` WRITE;
/*!40000 ALTER TABLE `student_support` DISABLE KEYS */;
/*!40000 ALTER TABLE `student_support` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `students`
--

DROP TABLE IF EXISTS `students`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `students` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `full_name` varchar(255) NOT NULL,
  `national_or_passport` varchar(200) NOT NULL,
  `phone` varchar(50) NOT NULL,
  `email` varchar(150) DEFAULT NULL,
  `mother_name` varchar(200) DEFAULT NULL,
  `birth_place` varchar(200) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `nearest_point` varchar(200) DEFAULT NULL,
  `gender` varchar(20) DEFAULT NULL,
  `guardian_phone1` varchar(50) DEFAULT NULL,
  `guardian_phone2` varchar(50) DEFAULT NULL,
  `student_photo` varchar(255) DEFAULT NULL,
  `pdf_file` varchar(255) DEFAULT NULL,
  `school_name` varchar(255) DEFAULT NULL,
  `branch` varchar(150) DEFAULT NULL,
  `graduation_year` varchar(10) DEFAULT NULL,
  `exam_round` enum('الدور الاول','الدور الثاني','الدور الثالث') DEFAULT NULL,
  `attempts` enum('نعم','لا') DEFAULT NULL,
  `fail_years` varchar(150) DEFAULT NULL,
  `exam_number` varchar(100) NOT NULL,
  `secret_number` varchar(100) DEFAULT NULL,
  `subjects_count` int(11) DEFAULT NULL,
  `total_score` int(11) DEFAULT NULL,
  `average` float DEFAULT NULL,
  `admission_channel` varchar(255) DEFAULT NULL,
  `university_name` varchar(255) DEFAULT NULL,
  `college_name` varchar(255) DEFAULT NULL,
  `study_type` enum('صباحي','مسائي') DEFAULT NULL,
  `app_username` varchar(150) DEFAULT NULL,
  `app_password` varchar(150) DEFAULT NULL,
  `dorm_request` enum('نعم','كلا') DEFAULT NULL,
  `status` enum('pending','verified','accepted') DEFAULT 'pending',
  `created_at` datetime DEFAULT current_timestamp(),
  `college_fee` int(11) NOT NULL DEFAULT 0,
  `wallet_balance` bigint(20) DEFAULT 0,
  `credit_score` int(11) DEFAULT 600,
  `risk_level` enum('منخفض','متوسط','عالي','خطير') DEFAULT 'متوسط',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `students`
--

LOCK TABLES `students` WRITE;
/*!40000 ALTER TABLE `students` DISABLE KEYS */;
INSERT INTO `students` VALUES (47,'gbhtbe','888778','07711035477','','jmjkkm','jikmkk','ijjjj','jmoio','ذكر','','',NULL,NULL,'jnjj','kkmkmkl','2005','الدور الاول','لا','','9','',9,900,100,'الشهداء','جامعة النبراس','هندسة الحاسبات','صباحي','','','كلا','accepted','2025-12-02 02:56:19',1900000,0,600,'متوسط');
/*!40000 ALTER TABLE `students` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `timeline_logs`
--

DROP TABLE IF EXISTS `timeline_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `timeline_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `event_type` enum('payment_add','payment_edit','installment_paid','installment_partial','installment_late','installment_created','discount_applied','plan_changed','level_changed','account_created','account_reset') NOT NULL,
  `amount` int(11) DEFAULT NULL,
  `installment_number` int(11) DEFAULT NULL,
  `old_value` varchar(255) DEFAULT NULL,
  `new_value` varchar(255) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  `finance_user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  CONSTRAINT `timeline_logs_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `timeline_logs`
--

LOCK TABLES `timeline_logs` WRITE;
/*!40000 ALTER TABLE `timeline_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `timeline_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wallet_transactions`
--

DROP TABLE IF EXISTS `wallet_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wallet_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `type` enum('إيداع','سحب','خصم قسط','إضافة قسط') NOT NULL,
  `amount` bigint(20) NOT NULL,
  `old_balance` bigint(20) NOT NULL,
  `new_balance` bigint(20) NOT NULL,
  `notes` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  CONSTRAINT `wallet_transactions_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wallet_transactions`
--

LOCK TABLES `wallet_transactions` WRITE;
/*!40000 ALTER TABLE `wallet_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `wallet_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whatsapp_templates`
--

DROP TABLE IF EXISTS `whatsapp_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `whatsapp_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `template_key` varchar(190) DEFAULT NULL,
  `template_text` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `template_key` (`template_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whatsapp_templates`
--

LOCK TABLES `whatsapp_templates` WRITE;
/*!40000 ALTER TABLE `whatsapp_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `whatsapp_templates` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-12-04 10:48:25
