<?php
// president/departments.php

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../config/app.php';

$PRESIDENT_KEY = "a"; // نفس المفتاح في dashboard.php

if (!isset($_GET['key']) || $_GET['key'] !== $PRESIDENT_KEY) {
    http_response_code(403);
    echo "غير مصرح لك بالدخول.";
    exit;
}

// تجميع الطلاب حسب الكلية + نوع الدراسة
$departments = $conn->query("
    SELECT 
        COALESCE(college_name,'غير محدد') AS college_name,
        COALESCE(study_type,'-') AS study_type,
        COUNT(*) AS students_count
    FROM students
    GROUP BY college_name, study_type
    ORDER BY students_count DESC, college_name ASC
")->fetchAll(PDO::FETCH_ASSOC);

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>لوحة الرئيس - الأقسام وعدد الطلاب</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body {
    margin: 0;
    min-height: 100vh;
    background: radial-gradient(circle at top, #1e293b, #020617);
    color: #e5e7eb;
    font-family: "Tajawal", sans-serif;
}
.header-bar {
    background: linear-gradient(90deg, #0f172a, #9333ea);
    padding: 15px 20px;
    display: flex;
    align-items: center;
    gap: 15px;
    box-shadow: 0 4px 20px rgba(0,0,0,0.4);
}
.header-bar img {
    width: 55px;
    height: 55px;
    border-radius: 999px;
    background: #fff;
}
.header-bar .title {
    font-size: 22px;
    font-weight: 700;
}
.header-bar .subtitle {
    font-size: 14px;
    opacity: 0.8;
}
.page-container {
    max-width: 1100px;
    margin: 25px auto 40px;
    padding: 0 15px 40px;
}
.glass-card {
    background: rgba(15,23,42,0.9);
    border-radius: 18px;
    padding: 20px 20px 10px;
    border: 1px solid rgba(148,163,184,0.35);
    box-shadow: 0 20px 60px rgba(15,23,42,0.8);
    margin-bottom: 25px;
}
.section-title {
    font-size: 20px;
    font-weight: 700;
    margin-bottom: 15px;
    display: flex;
    align-items: center;
    gap: 8px;
}
.section-title span.icon {
    width: 24px;
    height: 24px;
    border-radius: 999px;
    background: rgba(147,51,234,0.25);
    display: inline-flex;
    align-items: center;
    justify-content: center;
    font-size: 15px;
}
.table {
    color: #e5e7eb;
    font-size: 13px;
}
.table thead {
    background: rgba(15,23,42,0.9);
}
.table tbody tr:nth-child(even) {
    background: rgba(15,23,42,0.78);
}
.table tbody tr:nth-child(odd) {
    background: rgba(15,23,42,0.55);
}
.badge-dep {
    background: rgba(147,51,234,0.2);
    color: #e9d5ff;
    padding: 4px 10px;
    border-radius: 999px;
    font-size: 12px;
}
.badge-study {
    background: rgba(59,130,246,0.2);
    color: #bfdbfe;
    padding: 3px 8px;
    border-radius: 999px;
    font-size: 11px;
}
</style>
</head>
<body>

<div class="header-bar">
    <img src="../assets/images/logo.png" alt="شعار الجامعة">
    <div>
        <div class="title">جامعة النبراس الأهلية</div>
        <div class="subtitle">لوحة رئيس الجامعة – الأقسام وعدد طلابها</div>
    </div>
</div>

<div class="page-container">

    <div class="glass-card">
        <div class="section-title">
            <span class="icon">🏛️</span>
            توزيع الطلاب على الأقسام والبرامج الدراسية
        </div>

        <div class="table-responsive">
            <table class="table table-bordered align-middle text-center">
                <thead>
                    <tr>
                        <th style="width:45%">الكلية / القسم</th>
                        <th style="width:15%">نوع الدراسة</th>
                        <th style="width:20%">عدد الطلاب</th>
                        <th style="width:20%">نسبة تقريبية</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if (count($departments) == 0): ?>
                        <tr><td colspan="4">لا توجد بيانات حالياً.</td></tr>
                    <?php
                    else:
                        $total = array_sum(array_column($departments, 'students_count'));
                        foreach ($departments as $row):
                            $percent = $total > 0 ? round(($row['students_count'] / $total) * 100, 1) : 0;
                    ?>
                        <tr>
                            <td class="text-start">
                                <span class="badge-dep"><?= htmlspecialchars($row['college_name']) ?></span>
                            </td>
                            <td>
                                <span class="badge-study"><?= htmlspecialchars($row['study_type']) ?></span>
                            </td>
                            <td><?= number_format($row['students_count']) ?></td>
                            <td><?= $percent ?>%</td>
                        </tr>
                    <?php
                        endforeach;
                    endif;
                    ?>
                </tbody>
            </table>
        </div>
    </div>

</div>

</body>
</html>
