<?php
// president/finance.php

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../config/app.php';

$PRESIDENT_KEY = "a"; // نفس المفتاح

if (!isset($_GET['key']) || $_GET['key'] !== $PRESIDENT_KEY) {
    http_response_code(403);
    echo "غير مصرح لك بالدخول.";
    exit;
}

// ملخص مالي عام
$summary = $conn->query("
    SELECT 
        COUNT(accounts.id) AS accounts_count,
        COALESCE(SUM(accounts.total_fee),0) AS total_fee,
        COALESCE(SUM(accounts.paid),0) AS total_paid,
        COALESCE(SUM(accounts.remaining),0) AS total_remaining
    FROM accounts
")->fetch(PDO::FETCH_ASSOC);

// توزيع مالي حسب القسم / الدراسة
$by_department = $conn->query("
    SELECT 
        COALESCE(students.college_name,'غير محدد') AS college_name,
        COALESCE(students.study_type,'-') AS study_type,
        COUNT(accounts.id) AS accounts_count,
        COALESCE(SUM(accounts.total_fee),0) AS total_fee,
        COALESCE(SUM(accounts.paid),0) AS total_paid,
        COALESCE(SUM(accounts.remaining),0) AS total_remaining
    FROM accounts
    JOIN students ON accounts.student_id = students.id
    GROUP BY students.college_name, students.study_type
    ORDER BY total_fee DESC
")->fetchAll(PDO::FETCH_ASSOC);

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>لوحة الرئيس - الملخص المالي</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body {
    margin: 0;
    min-height: 100vh;
    background: radial-gradient(circle at top, #0f172a, #020617);
    color: #e5e7eb;
    font-family: "Tajawal", sans-serif;
}
.header-bar {
    background: linear-gradient(90deg, #0f172a, #16a34a);
    padding: 15px 20px;
    display: flex;
    align-items: center;
    gap: 15px;
    box-shadow: 0 4px 20px rgba(0,0,0,0.4);
}
.header-bar img {
    width: 55px;
    height: 55px;
    border-radius: 999px;
    background: #fff;
}
.header-bar .title {
    font-size: 22px;
    font-weight: 700;
}
.header-bar .subtitle {
    font-size: 14px;
    opacity: 0.8;
}
.page-container {
    max-width: 1200px;
    margin: 25px auto 40px;
    padding: 0 15px 40px;
}
.glass-card {
    background: rgba(15,23,42,0.9);
    border-radius: 18px;
    padding: 20px 20px 15px;
    border: 1px solid rgba(74,222,128,0.35);
    box-shadow: 0 20px 60px rgba(15,23,42,0.85);
    margin-bottom: 25px;
}
.section-title {
    font-size: 20px;
    font-weight: 700;
    margin-bottom: 15px;
    display: flex;
    align-items: center;
    gap: 8px;
}
.section-title span.icon {
    width: 24px;
    height: 24px;
    border-radius: 999px;
    background: rgba(22,163,74,0.25);
    display: inline-flex;
    align-items: center;
    justify-content: center;
    font-size: 15px;
}
.stat-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit,minmax(220px,1fr));
    gap: 15px;
}
.stat-box {
    border-radius: 16px;
    padding: 15px;
    background: radial-gradient(circle at top, rgba(22,163,74,0.45), rgba(15,23,42,0.97));
    border: 1px solid rgba(74,222,128,0.55);
}
.stat-label {
    font-size: 13px;
    opacity: 0.85;
}
.stat-value {
    font-size: 22px;
    font-weight: 700;
}
.stat-chip {
    display: inline-block;
    font-size: 11px;
    padding: 2px 8px;
    border-radius: 999px;
    background: rgba(15,23,42,0.9);
    border: 1px solid rgba(148,163,184,0.4);
    margin-top: 6px;
}
.table {
    color: #e5e7eb;
    font-size: 13px;
}
.table thead {
    background: rgba(15,23,42,0.9);
}
.table tbody tr:nth-child(even) {
    background: rgba(15,23,42,0.75);
}
.table tbody tr:nth-child(odd) {
    background: rgba(15,23,42,0.55);
}
.badge-dep {
    background: rgba(22,163,74,0.2);
    color: #bbf7d0;
    padding: 4px 10px;
    border-radius: 999px;
    font-size: 12px;
}
.badge-study {
    background: rgba(59,130,246,0.2);
    color: #bfdbfe;
    padding: 3px 8px;
    border-radius: 999px;
    font-size: 11px;
}
</style>
</head>
<body>

<div class="header-bar">
    <img src="../assets/images/logo.png" alt="شعار الجامعة">
    <div>
        <div class="title">جامعة النبراس الأهلية</div>
        <div class="subtitle">لوحة رئيس الجامعة – الملخص المالي للأقساط</div>
    </div>
</div>

<div class="page-container">

    <!-- ملخص عام -->
    <div class="glass-card">
        <div class="section-title">
            <span class="icon">💵</span>
            الملخص المالي العام لجميع الطلاب
        </div>
        <div class="stat-grid">
            <div class="stat-box">
                <div class="stat-label">عدد الطلاب الذين لديهم ملف مالي</div>
                <div class="stat-value"><?= number_format($summary['accounts_count']) ?></div>
                <div class="stat-chip">ملفات حسابات نشطة</div>
            </div>
            <div class="stat-box">
                <div class="stat-label">إجمالي الأقساط الكلية</div>
                <div class="stat-value"><?= number_format($summary['total_fee']) ?></div>
                <div class="stat-chip">دينار عراقي</div>
            </div>
            <div class="stat-box">
                <div class="stat-label">إجمالي المبالغ المدفوعة</div>
                <div class="stat-value"><?= number_format($summary['total_paid']) ?></div>
                <div class="stat-chip">ما تم تحصيله فعلياً</div>
            </div>
            <div class="stat-box">
                <div class="stat-label">إجمالي المبالغ المتبقية</div>
                <div class="stat-value"><?= number_format($summary['total_remaining']) ?></div>
                <div class="stat-chip">أقساط متبقية على الطلاب</div>
            </div>
        </div>
    </div>

    <!-- توزيع مالي حسب القسم -->
    <div class="glass-card">
        <div class="section-title">
            <span class="icon">📚</span>
            توزيع الأقساط حسب الكلية / القسم ونوع الدراسة
        </div>

        <div class="table-responsive">
            <table class="table table-bordered align-middle text-center">
                <thead>
                    <tr>
                        <th style="width:30%">الكلية / القسم</th>
                        <th style="width:10%">نوع الدراسة</th>
                        <th style="width:10%">عدد الطلبة</th>
                        <th style="width:15%">الأقساط الكلية</th>
                        <th style="width:15%">المدفوع</th>
                        <th style="width:15%">المتبقي</th>
                        <th style="width:5%">نسبة التحصيل</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (count($by_department) == 0): ?>
                        <tr><td colspan="7">لا توجد بيانات مالية حالياً.</td></tr>
                    <?php else: ?>
                        <?php foreach ($by_department as $row):
                            $rate = $row['total_fee'] > 0 ? round(($row['total_paid'] / $row['total_fee']) * 100, 1) : 0;
                        ?>
                        <tr>
                            <td class="text-start">
                                <span class="badge-dep"><?= htmlspecialchars($row['college_name']) ?></span>
                            </td>
                            <td><span class="badge-study"><?= htmlspecialchars($row['study_type']) ?></span></td>
                            <td><?= number_format($row['accounts_count']) ?></td>
                            <td><?= number_format($row['total_fee']) ?></td>
                            <td><?= number_format($row['total_paid']) ?></td>
                            <td><?= number_format($row['total_remaining']) ?></td>
                            <td><?= $rate ?>%</td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

    </div>

</div>

</body>
</html>
