<?php
session_start();
if (!isset($_SESSION["student_id"])) {
    header("Location: login.php");
    exit;
}

require_once "../config/db.php";

$student_id = $_SESSION["student_id"];

// جلب حالة الطالب فقط
$stmt = $conn->prepare("SELECT status FROM students WHERE id=? LIMIT 1");
$stmt->execute([$student_id]);
$info = $stmt->fetch(PDO::FETCH_ASSOC);

// حالة الطالب
$status = $info["status"];
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>حالة التقديم</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>

/* خلفية الصفحة */
body {
    background:#0f172a;
    color:white;
    font-family:"Tajawal", sans-serif;
    padding:25px;
}

/* كارد 2035 */
.status-card {
    background:rgba(255,255,255,0.06);
    border:1px solid rgba(255,255,255,0.15);
    border-radius:22px;
    padding:25px;
    backdrop-filter:blur(10px);
    box-shadow:0 8px 25px rgba(0,0,0,0.45);
    max-width:600px;
    margin:auto;
}

/* عنوان */
.section-title {
    font-size:23px;
    font-weight:800;
    color:#93c5fd;
    text-shadow:0 0 10px rgba(147,197,253,0.7);
    margin-bottom:25px;
    text-align:center;
}

/* --- Timeline --- */
.timeline {
    margin-top:10px;
}

.timeline-step {
    display:flex;
    align-items:center;
    gap:15px;
    margin-bottom:25px;
    transform-style:preserve-3d;
}

/* النقطة */
.dot {
    width:45px;
    height:45px;
    border-radius:50%;
    display:flex;
    justify-content:center;
    align-items:center;
    font-size:20px;
    border:3px solid transparent;
    transform:translateZ(10px);
    color:white;
}

/* خطوط بين النقاط */
.line {
    height:32px;
    margin: -10px 0 18px 20px;
    width:3px;
    border-radius:8px;
    background:linear-gradient(180deg,#64748b,#1e293b);
    box-shadow:0 0 8px rgba(255,255,255,0.15);
}

/* نص */
.step-text {
    font-size:19px;
    font-weight:700;
    text-shadow:0 0 8px rgba(255,255,255,0.25);
}

/* نيون لكل مرحلة */
.stage1 { background:#1e40af; border-color:#3b82f6; box-shadow:0 0 15px #3b82f6; }
.stage2 { background:#9a3412; border-color:#f97316; box-shadow:0 0 15px #fb923c; }
.stage3 { background:#14532d; border-color:#22c55e; box-shadow:0 0 15px #22c55e; }

/* الخطوة المكتملة */
.done .dot {
    transform:scale(1.25) translateZ(15px);
    animation:glow 1.6s infinite alternate;
}
.done .step-text { color:#22c55e; }

/* الحالية */
.current .dot {
    animation:pulse 1.2s infinite;
}
.current .step-text { color:#60a5fa; }

/* أنيميشن نبض */
@keyframes pulse {
    0% { transform:scale(1) translateZ(10px); }
    50% { transform:scale(1.2) translateZ(15px); }
    100% { transform:scale(1) translateZ(10px); }
}

/* وميض */
@keyframes glow {
    0%   { box-shadow:0 0 12px rgba(255,255,255,0.4); }
    100% { box-shadow:0 0 22px rgba(255,255,255,0.9); }
}

</style>
</head>

<body>

<div class="status-card">

    <div class="section-title">
        <i class="bi bi-clock-history"></i> حالة التقديم
    </div>

    <div class="timeline">

        <!-- 1️⃣ تم الاستلام -->
        <div class="timeline-step <?= ($status != 'pending') ? 'done' : 'current' ?>">
            <div class="dot stage1"><i class="bi bi-check-lg"></i></div>
            <div class="step-text">تم استلام الطلب</div>
        </div>
        <div class="line"></div>

        <!-- 2️⃣ قيد التدقيق -->
        <div class="timeline-step 
        <?= ($status == 'verified' || $status == 'accepted') ? 'done' : ($status == 'pending' ? '' : 'current') ?>">
            <div class="dot stage2"><i class="bi bi-hourglass-split"></i></div>
            <div class="step-text">قيد التدقيق</div>
        </div>
        <div class="line"></div>

        <!-- 3️⃣ تم القبول -->
        <div class="timeline-step <?= ($status == 'accepted') ? 'done' : '' ?>">
            <div class="dot stage3"><i class="bi bi-patch-check-fill"></i></div>
            <div class="step-text">تم القبول النهائي</div>
        </div>

    </div>

</div>

</body>
</html>