<?php
session_start();
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>تتبع باص الجامعة</title>

<style>
body {
    margin: 0;
    padding: 0;
    background: #0f172a;
    font-family: "Tajawal", sans-serif;
    color: #fff;
}

/* نافبار */
.navbar {
    background: rgba(15,23,42,0.95);
    padding: 14px 18px;
    display: flex;
    align-items: center;
    justify-content: space-between;
    backdrop-filter: blur(10px);
    border-bottom: 1px solid rgba(148,163,184,0.3);
    box-shadow: 0 4px 18px rgba(0,0,0,0.4);
}

.navbar .title {
    font-size: 17px;
    font-weight: 700;
}

.back-btn {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: rgba(255,255,255,0.08);
    border: 1px solid rgba(255,255,255,0.2);
    display: flex;
    justify-content: center;
    align-items: center;
    font-size: 22px;
    text-decoration: none;
    color: #fff;
}

/* حاوية الماب */
.map-container {
    width: 100%;
    max-width: 480px;
    margin: 0 auto;
    position: relative;
    padding-top: 10px;
}

/* صورة الطريق */
#road {
    width: 100%;
    border-radius: 14px;
    position: relative;
    z-index: 1;
    filter: brightness(0.9);
}

/* الباص */
#bus {
    position: absolute;
    width: 75px;
    z-index: 4;
    transition: all 1.2s cubic-bezier(.17,.67,.83,.67);
    transform: translate(-50%, -50%);
}

/* نص فوق الباص */
.bus-label {
    position: absolute;
    z-index: 5;
    padding: 4px 10px;
    background: rgba(0,0,0,0.6);
    color: #fff;
    border-radius: 10px;
    font-size: 12px;
    font-weight: 600;
    transform: translate(-50%, -120%);
    pointer-events: none;
}

/* أسماء المحطات */
.stop-label {
    position: absolute;
    z-index: 3;
    background: rgba(255,255,255,0.10);
    padding: 6px 14px;
    color: #fff;
    border-radius: 30px;
    font-size: 13px;
    font-weight: 700;
    display: none;
    backdrop-filter: blur(8px);
    border: 1px solid rgba(255,255,255,0.18);
}

/* صندوق الحالة */
.current-stop-box {
    margin: 20px auto 0;
    background: rgba(255,255,255,0.08);
    padding: 14px;
    font-size: 17px;
    max-width: 420px;
    border-radius: 14px;
    text-align: center;
    border: 1px solid rgba(255,255,255,0.18);
}

/* شريط التقدم */
.progress-container {
    width: 100%;
    max-width: 420px;
    margin: 15px auto;
    background: rgba(255,255,255,0.15);
    border-radius: 14px;
    height: 16px;
    overflow: hidden;
}

.progress-bar {
    height: 100%;
    width: 0%;
    background: linear-gradient(90deg,#3b82f6,#60a5fa);
    transition: width 1.1s ease-in-out;
}
</style>
</head>

<body>

<!-- نافبار -->
<div class="navbar">
    <div class="title">🚍 تتبع باص الجامعة</div>
    <a href="dashboard.php" class="back-btn">⟵</a>
</div>

<!-- صوت وصول -->
<audio id="busSound" src="../uploads/bus/bus.mp3" preload="auto"></audio>

<div class="map-container">

    <img id="road" src="../uploads/bus/stret.png">
    <img id="bus" src="../uploads/bus/bus.png">
    <div id="busLabel" class="bus-label"></div>

    <!-- محطات -->
    <div class="stop-label" id="stop0" style="top: 15%; left: 68%;">القادسية</div>
    <div class="stop-label" id="stop1" style="top: 33%; left: 38%;">شارع القادسية العام</div>
    <div class="stop-label" id="stop2" style="top: 49%; left: 72%;">مقابل شارع 60</div>
    <div class="stop-label" id="stop3" style="top: 65%; left: 30%;">مقابل المحكمة</div>
    <div class="stop-label" id="stop4" style="top: 82%; left: 55%;">انطلق إلى الجامعة</div>
    <div class="stop-label" id="stop5" style="top: 94%; left: 35%;">لقد وصل إلى الجامعة</div>

</div>

<div id="currentStop" class="current-stop-box">
    🚍 الباص – القادسية
</div>

<div class="progress-container">
    <div id="progressBar" class="progress-bar"></div>
</div>

<script>
const stops = [
    { top: "15%", left: "68%", name: "القادسية" },
    { top: "33%", left: "38%", name: "شارع القادسية العام" },
    { top: "49%", left: "72%", name: "مقابل شارع 60" },
    { top: "65%", left: "30%", name: "مقابل المحكمة" },
    { top: "82%", left: "55%", name: "انطلق إلى الجامعة" },
    { top: "94%", left: "35%", name: "لقد وصل إلى الجامعة" }
];

let index = 0;
const bus = document.getElementById("bus");
const busLabel = document.getElementById("busLabel");
const progressBar = document.getElementById("progressBar");
const currentStopText = document.getElementById("currentStop");
const busSound = document.getElementById("busSound");

function hideAll() {
    for (let i = 0; i < stops.length; i++) {
        document.getElementById("stop" + i).style.display = "none";
    }
}

function moveBus() {
    hideAll();

    bus.style.top = stops[index].top;
    bus.style.left = stops[index].left;

    busLabel.style.top = stops[index].top;
    busLabel.style.left = stops[index].left;

    document.getElementById("stop" + index).style.display = "block";

    currentStopText.innerHTML = "🚍 الباص – " + stops[index].name;

    // تشغيل الصوت
    busSound.currentTime = 0;
    busSound.play();

    progressBar.style.width = ((index + 1) / stops.length) * 100 + "%";

    index++;
    if (index >= stops.length) index = stops.length - 1;
}

// أول حركة
moveBus();

// تحديث تلقائي كل 10 ثوانٍ
setInterval(moveBus, 10000);
</script>

</body>
</html>