<?php
session_start();
if (!isset($_SESSION["student_id"])) { 
    header("Location: login.php"); 
    exit; 
}

require_once "../config/db.php";

$student_id = $_SESSION["student_id"];

$stmt = $conn->prepare("
    SELECT university_name, college_name, study_type, college_fee, status, created_at
    FROM students 
    WHERE id=? LIMIT 1
");
$stmt->execute([$student_id]);
$info = $stmt->fetch(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>بيانات الكلية</title>

<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>

body {
    margin:0;
    padding:0;
    background:#020617;
    font-family:"Tajawal", sans-serif;
    color:white;
    overflow-x:hidden;
}

/* ==============================
   غلاف التطبيق (يشبه واجهة تطبيق موبايل)
============================== */
.app-shell {
    min-height:100vh;
    max-width:480px;
    margin:0 auto;
    background:radial-gradient(circle at top, #0f172a, #020617);
    display:flex;
    flex-direction:column;
    box-shadow:0 0 35px rgba(0,0,0,0.7);
}

/* ==============================
   الهيدر
============================== */
.navbar-custom {
    background:linear-gradient(135deg,#1e293b,#2563eb);
    padding:15px 18px;
    display:flex;
    align-items:center;
    justify-content:space-between;
    border-radius:0 0 16px 16px;
    position:sticky;
    top:0;
    z-index:20;
    box-shadow:0 4px 20px rgba(0,0,0,0.45);
}

.navbar-custom .title {
    font-size:16px;
    font-weight:700;
    color:#bfdbfe;
}

.navbar-custom a {
    color:white;
    font-size:18px;
}

/* ==============================
   المحتوى
============================== */
.container-app {
    padding:18px 14px 80px;
}

/* ==============================
   الكارد الزجاجي
============================== */
.card-glass {
    background:rgba(255,255,255,0.06);
    border-radius:18px;
    padding:18px;
    border:1px solid rgba(255,255,255,0.12);
    backdrop-filter:blur(10px);
    margin-bottom:20px;
    animation:fadeIn .8s ease;
    box-shadow:0 8px 25px rgba(0,0,0,0.45);
}

.section-title {
    font-size:15px;
    font-weight:700;
    margin-bottom:12px;
    color:#93c5fd;
}

/* ==============================
   مربعات المعلومات
============================== */
.info-box {
    background:rgba(255,255,255,0.05);
    padding:14px 16px;
    border-radius:14px;
    display:flex;
    gap:12px;
    border:1px solid rgba(255,255,255,0.12);
    margin-bottom:12px;
}

.info-box i {
    font-size:22px;
    color:#60a5fa;
}

.label {
    color:#cbd5e1;
    font-size:12px;
}

.value {
    font-size:15px;
    font-weight:700;
}

/* ==============================
   الخط الزمني (Timeline)
============================== */
.timeline-step {
    display:flex;
    align-items:center;
    margin-bottom:10px;
}

.timeline-step .dot {
    width:16px;
    height:16px;
    border-radius:50%;
    margin-left:10px;
    background:#475569;
    border:3px solid #64748b;
}

.timeline-step .text {
    font-size:14px;
    font-weight:600;
}

/* منجز */
.timeline-step.done .dot {
    background:#4ade80;
    border-color:#22c55e;
}
.timeline-step.done .text {
    color:#4ade80;
}

/* الحالي */
.timeline-step.current .dot {
    background:#60a5fa;
    border-color:#3b82f6;
}
.timeline-step.current .text {
    color:#60a5fa;
}

/* خط بين النقاط */
.line {
    width:2px;
    height:22px;
    background:#334155;
    margin:0 0 10px 6px;
}

/* أنيميشن */
@keyframes fadeIn {
    from {opacity:0; transform:translateY(15px);}
    to   {opacity:1; transform:translateY(0);}
}

@media (max-width:360px) {
    .value { font-size:14px; }
    .section-title { font-size:14px; }
}

</style>
</head>

<body>

<div class="app-shell">

    <!-- الهيدر -->
    <div class="navbar-custom">
        <span class="title"><i class="bi bi-building"></i> بيانات الكلية</span>
        <a href="dashboard.php"><i class="bi bi-arrow-right"></i></a>
    </div>

    <div class="container-app">

        <!-- معلومات أكاديمية -->
        <div class="card-glass">

            <div class="section-title">
                <i class="bi bi-mortarboard-fill"></i> معلوماتك الأكاديمية
            </div>

            <div class="info-box">
                <i class="bi bi-bank"></i>
                <div>
                    <div class="label">الجامعة</div>
                    <div class="value"><?= $info["university_name"] ?></div>
                </div>
            </div>

            <div class="info-box">
                <i class="bi bi-diagram-3-fill"></i>
                <div>
                    <div class="label">القسم</div>
                    <div class="value"><?= $info["college_name"] ?></div>
                </div>
            </div>

            <div class="info-box">
                <i class="bi bi-journal-bookmark"></i>
                <div>
                    <div class="label">نوع الدراسة</div>
                    <div class="value"><?= $info["study_type"] ?></div>
                </div>
            </div>

            <div class="info-box">
                <i class="bi bi-cash-coin"></i>
                <div>
                    <div class="label">القسط السنوي</div>
                    <div class="value"><?= number_format($info["college_fee"]) ?> د.ع</div>
                </div>
            </div>

            <div class="info-box">
                <i class="bi bi-calendar-check"></i>
                <div>
                    <div class="label">تاريخ التقديم</div>
                    <div class="value"><?= $info["created_at"] ?></div>
                </div>
            </div>

        </div>

        <!-- Timeline -->
        <div class="card-glass">

            <div class="section-title">
                <i class="bi bi-clock-history"></i> حالة التقديم
            </div>

            <div class="timeline">

                <!-- خطوة 1 -->
                <div class="timeline-step <?= ($info["status"] !== "pending") ? 'done' : 'current' ?>">
                    <div class="dot"></div>
                    <div class="text">تم استلام الطلب</div>
                </div>
                <div class="line"></div>

                <!-- خطوة 2 -->
                <div class="timeline-step <?= ($info["status"] == "verified" || $info["status"] == "accepted") ? 'done' : (($info["status"] == "pending") ? '' : 'current') ?>">
                    <div class="dot"></div>
                    <div class="text">قيد التدقيق</div>
                </div>
                <div class="line"></div>

                <!-- خطوة 3 -->
                <div class="timeline-step <?= ($info["status"] == "accepted") ? 'done' : '' ?>">
                    <div class="dot"></div>
                    <div class="text">تم القبول النهائي</div>
                </div>

            </div>

        </div>

    </div>

</div>

</body>
</html>