<?php
session_start();
require_once "../config/db.php";
require_once "../config/security.php";

$error = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {

    $phone = sanitize($_POST["phone"]);

    $stmt = $conn->prepare("SELECT id, full_name FROM students WHERE phone=? LIMIT 1");
    $stmt->execute([$phone]);
    $student = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($student) {

        $_SESSION['student_id'] = $student['id'];
        $_SESSION['student_name'] = $student['full_name'];

        header("Location: dashboard.php");
        exit;

    } else {
        $error = "رقم الهاتف غير مسجل في النظام.";
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
<meta charset="UTF-8">
<title>تسجيل دخول الطالب</title>

<link rel="stylesheet"
href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">

<link rel="stylesheet"
href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">

<style>

body {
    margin:0;
    padding:0;
    height:100vh;
    display:flex;
    justify-content:center;
    align-items:center;
    background:linear-gradient(160deg,#0f172a,#1e1b4b,#312e81);
    background-size:300% 300%;
    animation:bgMove 8s ease infinite;
    font-family:"Tajawal";
    color:white;
}

@keyframes bgMove {
    0% {background-position:0% 50%;}
    50% {background-position:100% 50%;}
    100% {background-position:0% 50%;}
}

.login-container {
    width:95%;
    max-width:420px;
    background:rgba(255,255,255,0.08);
    backdrop-filter:blur(12px);
    border-radius:22px;
    padding:35px 30px;
    border:1px solid rgba(255,255,255,0.18);
    box-shadow:0 10px 35px rgba(0,0,0,0.5);
    animation:fadeIn 1s ease;
}

@keyframes fadeIn {
    from {opacity:0;transform:translateY(20px);}
    to {opacity:1;transform:translateY(0);}
}

/* صندوق الشعار */
.logo-box {
    display:flex;
    justify-content:center;
    margin-bottom:25px;
}

/* الشعار الأساسي */
.logo-box img {
    width:140px;
    height:140px;
    object-fit:contain;
    padding:18px;
    background:rgba(255,255,255,0.08);
    border-radius:28px;
    border:1px solid rgba(255,255,255,0.25);
    box-shadow:
        0 0 25px rgba(99,102,241,0.4),
        0 0 45px rgba(99,102,241,0.2),
        inset 0 0 22px rgba(255,255,255,0.1);
    backdrop-filter:blur(8px);
    position:relative;
    animation:logoFadeIn 1.5s ease-out;
}

/* اللمعة المتحركة */
.logo-box img::after {
    content:"";
    position:absolute;
    top:0;
    left:-150%;
    width:140%;
    height:100%;
    background: linear-gradient(
        120deg,
        transparent 0%,
        rgba(255,255,255,0.4) 45%,
        rgba(255,255,255,0.9) 50%,
        rgba(255,255,255,0.4) 55%,
        transparent 100%
    );
    transform:skewX(-25deg);
    animation:shineMove 3s ease-in-out infinite;
}

/* انعكاس تحت الشعار */
.logo-reflection {
    width:140px;
    height:40px;
    background:linear-gradient(to bottom,
        rgba(255,255,255,0.25),
        rgba(255,255,255,0)
    );
    filter:blur(5px);
    border-radius:50%;
    margin:0 auto -10px auto;
    opacity:0.35;
}

/* أنيميشن */
@keyframes shineMove {
    0% { left:-150%; }
    50% { left:150%; }
    100% { left:-150%; }
}

@keyframes logoFadeIn {
    0% { opacity:0; transform:scale(0.7); }
    100% { opacity:1; transform:scale(1); }
}
.page-title {
    text-align:center;
    font-size:23px;
    font-weight:800;
    margin-bottom:18px;
    color:#dbeafe;
}

.input-group-text {
    background:rgba(255,255,255,0.15);
    border:1px solid rgba(255,255,255,0.25);
    color:#cbd5e1;
}

.form-control {
    background:rgba(255,255,255,0.10);
    border:1px solid rgba(255,255,255,0.25);
    color:white;
    padding:12px;
}

.form-control:focus {
    background:rgba(255,255,255,0.15);
    box-shadow:none;
    border-color:#93c5fd;
}

.btn-login {
    background:linear-gradient(90deg,#3b82f6,#6366f1);
    border:none;
    padding:12px;
    font-size:17px;
    font-weight:700;
    border-radius:12px;
    width:100%;
    margin-top:10px;
    transition:0.25s;
}

.btn-login:hover {
    opacity:0.9;
    transform:scale(1.02);
}

.footer-text {
    text-align:center;
    margin-top:20px;
    color:#cbd5e1;
    font-size:14px;
}

</style>
</head>

<body>

<div class="login-container">

    <div class="logo-box">
    <img src="../assets/img/logo.png" alt="شعار الجامعة">
</div>
<div class="logo-reflection"></div>

    <div class="page-title">🔐 تسجيل دخول الطالب</div>

    <?php if ($error): ?>
        <div class="alert alert-danger text-center"><?= $error ?></div>
    <?php endif; ?>

    <form method="POST">

        <label class="mb-1">رقم الهاتف</label>
        <div class="input-group mb-3">
            <span class="input-group-text">
                <i class="bi bi-phone"></i>
            </span>
            <input type="text" name="phone" class="form-control" placeholder="أدخل رقم الهاتف" required>
        </div>

        <button class="btn-login">دخول <i class="bi bi-arrow-left-circle"></i></button>
    </form>

    <div class="footer-text">
        نظام تسجيل طلاب – جامعة النبراس
    </div>

</div>

</body>
</html>