<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
<meta charset="UTF-8">
<title>تم إرسال طلبك بنجاح</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
body {
    margin:0;
    padding:0;
    height:100vh;
    background: radial-gradient(circle at top, #0f172a, #1e1b4b);
    color:white;
    font-family:"Tajawal", sans-serif;
    display:flex;
    justify-content:center;
    align-items:center;
    overflow:hidden;
    position:relative;
}

/* خلفية الشعار */
body::before {
    content:"";
    position:absolute;
    top:50%;
    left:50%;
    width:550px;
    height:550px;
    background:url('assets/img/logo.png') no-repeat center;
    background-size:contain;
    opacity:0.05;
    transform:translate(-50%, -50%);
    filter:blur(2px);
}

/* صندوق الرسالة */
.success-box {
    position:relative;
    background:rgba(255,255,255,0.07);
    border:1px solid rgba(255,255,255,0.15);
    width:90%;
    max-width:700px;
    padding:55px 55px 90px;
    text-align:center;
    border-radius:22px;
    box-shadow:0 15px 50px rgba(0,0,0,0.5);
    animation:fadeIn 1.4s ease-out;
    backdrop-filter:blur(7px);
}

.logo {
    width:140px;
    margin-bottom:25px;
    filter:drop-shadow(0 0 12px #000);
    animation:popIn 1.3s ease-out;
}

h1 {
    font-size:46px;
    font-weight:800;
    margin-bottom:15px;
    background:linear-gradient(90deg,#60a5fa,#818cf8);
    -webkit-background-clip:text;
    -webkit-text-fill-color:transparent;
    animation:slideDown 1.2s ease-out;
}

p {
    font-size:19px;
    color:#dbeafe;
    margin-bottom:8px;
    animation:fadeIn 2s ease-out;
}

/* زر احترافي */
.btn-main {
    margin-top:35px;
    padding:15px 45px;
    font-size:20px;
    font-weight:600;
    border-radius:14px;
    border:0;
    background:linear-gradient(90deg,#3b82f6,#6366f1);
    color:white;
    cursor:pointer;
    display:inline-flex;
    align-items:center;
    gap:10px;
    box-shadow:0 10px 25px rgba(0,0,0,0.35);
    position:relative;
    overflow:hidden;
    text-decoration:none !important;
    transition:0.25s ease-in-out;
}

/* تأثير اللمعة */
.btn-main::before {
    content:"";
    position:absolute;
    top:0;
    left:-150%;
    width:120%;
    height:100%;
    background:linear-gradient(
        110deg,
        rgba(255,255,255,0) 0%,
        rgba(255,255,255,0.12) 40%,
        rgba(255,255,255,0.4) 50%,
        rgba(255,255,255,0.12) 60%,
        rgba(255,255,255,0) 100%
    );
    transform:skewX(-25deg);
    transition:0.55s ease-out;
}

.btn-main:hover::before {
    left:150%;
}

.btn-main i {
    transition:0.35s;
}

.btn-main:hover i {
    transform:translateX(7px);
}

.btn-main:hover {
    transform:translateY(-4px);
    box-shadow:0 14px 30px rgba(0,0,0,0.45);
}

/* أنيميشن عام */
@keyframes fadeIn {
    from {opacity:0; transform:translateY(15px);}
    to   {opacity:1; transform:translateY(0);}
}
@keyframes slideDown {
    from {opacity:0; transform:translateY(-15px);}
    to   {opacity:1; transform:translateY(0);}
}
@keyframes popIn {
    0% {opacity:0; transform:scale(0.5);}
    100% {opacity:1; transform:scale(1);}
}
</style>

</head>
<body>

<div class="success-box">

    <img src="assets/img/logo.png" class="logo">

    <h1>تم تقديم طلبك بنجاح</h1>

    <p>نشكرك على ثقتك بجامعة النبراس الأهلية.</p>
    <p>تم استلام بياناتك عبر بوابة التقديم الإلكترونية.</p>

    <p style="margin-top:22px;font-size:17px;color:#a5b4fc;">
        سيقوم قسم التسجيل بالتواصل معك قريبًا لإكمال الإجراءات الرسمية.
    </p>

    <!-- زر الرجوع للصفحة الرئيسية -->
    <a href="index.php" class="btn-main">
        العودة للصفحة الرئيسية <i class="bi bi-arrow-right-circle"></i>
    </a>

    <!-- زر الذهاب إلى صفحة الطالب -->
    <a href="student/dashboard.php" class="btn-main" style="margin-top:18px; background:linear-gradient(90deg,#22c55e,#16a34a);">
        الذهاب إلى لوحة الطالب <i class="bi bi-person-circle"></i>
    </a>

</div>

</body>
</html>