<?php
session_start();
if(!isset($_SESSION['finance_user'])){ header("Location: login.php"); exit; }

require_once "../config/db.php";
require_once "includes/header.php";
require_once "includes/navbar.php";
require_once "../config/app.php";

/* ============================================
   🔹 (A) الإحصائيات الأساسية
============================================ */
$total_students = $conn->query("SELECT COUNT(*) FROM students WHERE status='accepted'")->fetchColumn();
$total_male     = $conn->query("SELECT COUNT(*) FROM students WHERE gender='ذكر' AND status='accepted'")->fetchColumn();
$total_female   = $conn->query("SELECT COUNT(*) FROM students WHERE gender='انثى' AND status='accepted'")->fetchColumn();

$total_fee       = $conn->query("SELECT SUM(total_fee) FROM accounts")->fetchColumn() ?? 0;          // إجمالي ما يجب تحصيله (ديون على الطلاب)
$total_paid      = $conn->query("SELECT SUM(paid) FROM accounts")->fetchColumn() ?? 0;               // ما تم تحصيله فعلاً
$total_remaining = $conn->query("SELECT SUM(remaining) FROM accounts")->fetchColumn() ?? 0;          // المبالغ المتبقية (ديون قائمة)

/* خزنة تقريبية (يمكن لاحقاً تربطها بجداول الخزنة) */
$cashbox_balance = $total_paid; // حالياً نفترض كل المدفوع دخل الخزنة

/* ============================================
   🔹 (B) تحليلات مالية (طرق الدفع + اليوم/الأسبوع/الشهر)
============================================ */
// طرق الدفع
$paymentTypes = $conn->query("
    SELECT payment_type, COUNT(*) AS cnt, SUM(amount) AS total
    FROM payments
    GROUP BY payment_type
")->fetchAll(PDO::FETCH_ASSOC);

// اليوم / الأسبوع / الشهر
$today      = date('Y-m-d');
$week_start = date('Y-m-d', strtotime('monday this week'));
$month_start= date('Y-m-01');

$today_total = $conn->prepare("SELECT SUM(amount) FROM payments WHERE DATE(paid_at) = ?");
$today_total->execute([$today]);
$today_total = $today_total->fetchColumn() ?? 0;

$week_total = $conn->prepare("SELECT SUM(amount) FROM payments WHERE DATE(paid_at) BETWEEN ? AND ?");
$week_total->execute([$week_start, $today]);
$week_total = $week_total->fetchColumn() ?? 0;

$month_total = $conn->prepare("SELECT SUM(amount) FROM payments WHERE DATE(paid_at) BETWEEN ? AND ?");
$month_total->execute([$month_start, $today]);
$month_total = $month_total->fetchColumn() ?? 0;

/* ============================================
   🔹 (C) رسوم بيانية: إحصائية الطلاب حسب الأقسام
============================================ */
$colleges = $conn->query("
    SELECT college_name, COUNT(*) AS total
    FROM students
    WHERE status='accepted'
    GROUP BY college_name
")->fetchAll(PDO::FETCH_ASSOC);

/* رسوم بيانية: الإيراد آخر 7 أيام */
$rev7 = $conn->query("
    SELECT DATE(paid_at) AS d, SUM(amount) AS total
    FROM payments
    WHERE paid_at >= DATE_SUB(CURDATE(), INTERVAL 6 DAY)
    GROUP BY DATE(paid_at)
    ORDER BY d
")->fetchAll(PDO::FETCH_ASSOC);

/* ============================================
   🔹 (D) ديون متأخرة Debt Aging
   نعتمد على last_update + remaining كتصنيف مبدئي
============================================ */
$agingAmounts = $conn->query("
    SELECT
        SUM(CASE WHEN remaining > 0 AND DATEDIFF(CURDATE(), last_update) BETWEEN 0 AND 30  THEN remaining ELSE 0 END) AS d0_30,
        SUM(CASE WHEN remaining > 0 AND DATEDIFF(CURDATE(), last_update) BETWEEN 31 AND 60 THEN remaining ELSE 0 END) AS d31_60,
        SUM(CASE WHEN remaining > 0 AND DATEDIFF(CURDATE(), last_update) BETWEEN 61 AND 90 THEN remaining ELSE 0 END) AS d61_90,
        SUM(CASE WHEN remaining > 0 AND DATEDIFF(CURDATE(), last_update) > 90 THEN remaining ELSE 0 END) AS d90_plus
    FROM accounts
")->fetch(PDO::FETCH_ASSOC);

$agingCounts = $conn->query("
    SELECT
        SUM(CASE WHEN remaining > 0 AND DATEDIFF(CURDATE(), last_update) BETWEEN 0 AND 30  THEN 1 ELSE 0 END) AS c0_30,
        SUM(CASE WHEN remaining > 0 AND DATEDIFF(CURDATE(), last_update) BETWEEN 31 AND 60 THEN 1 ELSE 0 END) AS c31_60,
        SUM(CASE WHEN remaining > 0 AND DATEDIFF(CURDATE(), last_update) BETWEEN 61 AND 90 THEN 1 ELSE 0 END) AS c61_90,
        SUM(CASE WHEN remaining > 0 AND DATEDIFF(CURDATE(), last_update) > 90 THEN 1 ELSE 0 END) AS c90_plus
    FROM accounts
")->fetch(PDO::FETCH_ASSOC);

/* ============================================
   🔹 (E) Top Lists – الطلاب
============================================ */
// أعلى 10 طلاب دفعاً
$topPaid = $conn->query("
    SELECT s.full_name, a.paid, a.remaining
    FROM accounts a
    JOIN students s ON s.id = a.student_id
    WHERE s.status='accepted'
    ORDER BY a.paid DESC
    LIMIT 10
")->fetchAll(PDO::FETCH_ASSOC);

// أعلى 10 طلاب ديوناً
$topDebtors = $conn->query("
    SELECT s.full_name, a.paid, a.remaining
    FROM accounts a
    JOIN students s ON s.id = a.student_id
    WHERE s.status='accepted'
    ORDER BY a.remaining DESC
    LIMIT 10
")->fetchAll(PDO::FETCH_ASSOC);

// طلاب بدون أي دفعة
$noPayments = $conn->query("
    SELECT s.full_name, a.total_fee, a.remaining
    FROM accounts a
    JOIN students s ON s.id = a.student_id
    WHERE s.status='accepted' AND a.paid = 0
    ORDER BY a.total_fee DESC
    LIMIT 10
")->fetchAll(PDO::FETCH_ASSOC);

?>
<style>
/* ارتفاع ثابت للشارتات – يمنع التمدد */
canvas {
    height: 240px !important;
    max-height: 240px !important;
}

/* حاوية الشارت الزجاجية */
.chart-card{
    background: linear-gradient(135deg, rgba(15,23,42,0.96), rgba(15,23,42,0.9));
    border-radius:18px;
    padding:18px 20px;
    margin-bottom:18px;
    border:1px solid rgba(148,163,184,0.5);
    box-shadow:0 18px 45px rgba(0,0,0,0.75);
    position:relative;
    overflow:hidden;
    color:#e5e7eb;
}
.chart-card::before{
    content:"";
    position:absolute;
    inset:-40%;
    background:
        radial-gradient(circle at top left, rgba(59,130,246,0.18), transparent 55%),
        radial-gradient(circle at bottom right, rgba(34,197,94,0.12), transparent 55%);
    opacity:0.9;
    pointer-events:none;
}
.chart-card h5{
    position:relative;
    z-index:1;
    font-size:15px;
    font-weight:600;
    margin-bottom:8px;
    color:#e5e7eb;
}
.chart-card canvas{
    position:relative;
    z-index:1;
}

/* Glass Cards عادية للإحصائيات */
.card-box{
    background:rgba(15,23,42,0.9);
    border-radius:16px;
    padding:18px;
    margin-bottom:15px;
    border:1px solid rgba(148,163,184,0.4);
    box-shadow:0 10px 30px rgba(0,0,0,0.5);
    color:#e5e7eb;
}
.card-box h5{
    font-size:14px;
    color:#9ca3af;
    margin-bottom:8px;
}
.card-box h2{
    font-size:24px;
    font-weight:800;
}

/* عناوين فرعية */
.block-title{
    font-size:18px;
    font-weight:700;
    margin:25px 0 15px;
    color:#e5e7eb;
}

/* جداول صغيرة */
.table-dark-sm td,
.table-dark-sm th{
    padding:6px 10px;
    font-size:13px;
}
.badge-soft{
    background:rgba(148,163,184,0.15);
    border:1px solid rgba(148,163,184,0.5);
    color:#e5e7eb;
}

/* بطاقة ديون */
.debt-card{
    background:rgba(15,23,42,0.9);
    border-radius:14px;
    border:1px solid rgba(239,68,68,0.35);
    padding:14px;
    margin-bottom:10px;
}
</style>

<div class="container my-4">

    <h2 class="mb-4">
        <i class="bi bi-speedometer2"></i> لوحة الحسابات المالية
    </h2>

    <!-- ==============================
         A) ملخص أساسي
    =============================== -->
    <div class="row">

        <div class="col-md-3 col-6">
            <div class="card-box text-center">
                <h5>إجمالي الطلاب المقبولين</h5>
                <h2><?= number_format($total_students) ?></h2>
            </div>
        </div>

        <div class="col-md-3 col-6">
            <div class="card-box text-center">
                <h5>الطلاب الذكور</h5>
                <h2><?= number_format($total_male) ?></h2>
            </div>
        </div>

        <div class="col-md-3 col-6">
            <div class="card-box text-center">
                <h5>الطالبات الإناث</h5>
                <h2><?= number_format($total_female) ?></h2>
            </div>
        </div>

        <div class="col-md-3 col-6">
            <div class="card-box text-center">
                <h5>إجمالي الرسوم (ديون على الطلاب)</h5>
                <h2><?= number_format($total_fee) ?> <small>د.ع</small></h2>
            </div>
        </div>

    </div>

    <!-- ==============================
         B) ملخص مالي متقدم
    =============================== -->
    <div class="row mt-2">

        <div class="col-md-4">
            <div class="card-box text-center">
                <h5>المبالغ المحصّلة فعلياً</h5>
                <h2 class="text-success"><?= number_format($total_paid) ?> <small>د.ع</small></h2>
                <span class="badge bg-success mt-2">هذه الأموال دخلت الخزنة / الحسابات</span>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card-box text-center">
                <h5>المبالغ المتبقية على الطلاب</h5>
                <h2 class="text-danger"><?= number_format($total_remaining) ?> <small>د.ع</small></h2>
                <span class="badge bg-danger mt-2">ديون قائمة لم تُحصّل بعد</span>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card-box text-center">
                <h5>رصيد الخزنة التقديري</h5>
                <h2 class="text-info"><?= number_format($cashbox_balance) ?> <small>د.ع</small></h2>
                <span class="badge bg-info text-dark mt-2">يمكن لاحقاً ربطها بجداول الخزنة الفعلية</span>
            </div>
        </div>

    </div>

    <!-- سطر اليوم / الأسبوع / الشهر -->
    <div class="row mt-3">

        <div class="col-md-4">
            <div class="card-box text-center">
                <h5>تحصيل اليوم (<?= $today ?>)</h5>
                <h2 class="text-success"><?= number_format($today_total) ?> <small>د.ع</small></h2>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card-box text-center">
                <h5>تحصيل هذا الأسبوع</h5>
                <h2 class="text-success"><?= number_format($week_total) ?> <small>د.ع</small></h2>
                <span class="badge badge-soft">من <?= $week_start ?> إلى <?= $today ?></span>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card-box text-center">
                <h5>تحصيل هذا الشهر</h5>
                <h2 class="text-success"><?= number_format($month_total) ?> <small>د.ع</small></h2>
                <span class="badge badge-soft">من <?= $month_start ?> إلى <?= $today ?></span>
            </div>
        </div>

    </div>

    <hr class="text-secondary my-4">

    <!-- ==============================
         D) ديون متأخرة (Debt Aging)  ← فوق الشارتات
    =============================== -->
    <h4 class="block-title">⏰ تحليل الديون حسب مدة التأخير</h4>
    <div class="row">

        <div class="col-md-3 col-6">
            <div class="debt-card">
                <div class="fw-bold text-muted">0 – 30 يوم</div>
                <div class="mt-1">
                    <span class="text-warning">طلاب: <?= (int)$agingCounts['c0_30'] ?></span><br>
                    <span>المبلغ: <strong><?= number_format($agingAmounts['d0_30'] ?? 0) ?> د.ع</strong></span>
                </div>
            </div>
        </div>

        <div class="col-md-3 col-6">
            <div class="debt-card">
                <div class="fw-bold text-muted">31 – 60 يوم</div>
                <div class="mt-1">
                    <span class="text-warning">طلاب: <?= (int)$agingCounts['c31_60'] ?></span><br>
                    <span>المبلغ: <strong><?= number_format($agingAmounts['d31_60'] ?? 0) ?> د.ع</strong></span>
                </div>
            </div>
        </div>

        <div class="col-md-3 col-6">
            <div class="debt-card">
                <div class="fw-bold text-muted">61 – 90 يوم</div>
                <div class="mt-1">
                    <span class="text-warning">طلاب: <?= (int)$agingCounts['c61_90'] ?></span><br>
                    <span>المبلغ: <strong><?= number_format($agingAmounts['d61_90'] ?? 0) ?> د.ع</strong></span>
                </div>
            </div>
        </div>

        <div class="col-md-3 col-6">
            <div class="debt-card">
                <div class="fw-bold text-danger">+ 90 يوم (ديون خطرة)</div>
                <div class="mt-1">
                    <span class="text-warning">طلاب: <?= (int)$agingCounts['c90_plus'] ?></span><br>
                    <span>المبلغ: <strong><?= number_format($agingAmounts['d90_plus'] ?? 0) ?> د.ع</strong></span>
                </div>
            </div>
        </div>

    </div>

    <hr class="text-secondary my-4">

    <!-- ==============================
         E) Top Lists – الطلاب  ← فوق الشارتات
    =============================== -->
    <div class="row">
        <div class="col-lg-4">
            <h4 class="block-title">🏅 أعلى 10 طلاب دفعاً</h4>
            <div class="card-box p-2">
                <table class="table table-dark table-striped table-dark-sm mb-0 text-center">
                    <thead>
                        <tr>
                            <th>الطالب</th>
                            <th>مدفوع</th>
                            <th>متبقي</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($topPaid as $row): ?>
                        <tr>
                            <td><?= htmlspecialchars($row['full_name']) ?></td>
                            <td class="text-success"><?= number_format($row['paid']) ?></td>
                            <td class="text-danger"><?= number_format($row['remaining']) ?></td>
                        </tr>
                        <?php endforeach; ?>
                        <?php if(!$topPaid): ?>
                        <tr><td colspan="3">لا توجد بيانات حالياً</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="col-lg-4">
            <h4 class="block-title">🚨 أعلى 10 طلاب ديوناً</h4>
            <div class="card-box p-2">
                <table class="table table-dark table-striped table-dark-sm mb-0 text-center">
                    <thead>
                        <tr>
                            <th>الطالب</th>
                            <th>مدفوع</th>
                            <th>متبقي</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($topDebtors as $row): ?>
                        <tr>
                            <td><?= htmlspecialchars($row['full_name']) ?></td>
                            <td class="text-success"><?= number_format($row['paid']) ?></td>
                            <td class="text-danger"><?= number_format($row['remaining']) ?></td>
                        </tr>
                        <?php endforeach; ?>
                        <?php if(!$topDebtors): ?>
                        <tr><td colspan="3">لا توجد بيانات حالياً</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="col-lg-4">
            <h4 class="block-title">🧾 طلاب لم يسددوا أي مبلغ</h4>
            <div class="card-box p-2">
                <table class="table table-dark table-striped table-dark-sm mb-0 text-center">
                    <thead>
                        <tr>
                            <th>الطالب</th>
                            <th>الرسوم الكلية</th>
                            <th>متبقي</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($noPayments as $row): ?>
                        <tr>
                            <td><?= htmlspecialchars($row['full_name']) ?></td>
                            <td><?= number_format($row['total_fee']) ?></td>
                            <td class="text-danger"><?= number_format($row['remaining']) ?></td>
                        </tr>
                        <?php endforeach; ?>
                        <?php if(!$noPayments): ?>
                        <tr><td colspan="3">لا توجد بيانات حالياً</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <hr class="text-secondary my-4">

    <!-- ==============================
         C) الرسوم البيانية – شارتات زجاجية أنيقة في أسفل الصفحة
    =============================== -->
    <div class="row">
        <!-- الطلاب حسب الأقسام -->
        <div class="col-lg-6">
            <div class="chart-card">
                <h5 class="mb-2">📊 إحصائية الطلاب حسب الأقسام</h5>
                <canvas id="chartColleges"></canvas>
            </div>
        </div>

        <!-- طرق الدفع -->
        <div class="col-lg-6">
            <div class="chart-card">
                <h5 class="mb-2">💳 توزيع طرق الدفع</h5>
                <canvas id="chartPaymentTypes"></canvas>
            </div>
        </div>
    </div>

    <!-- إيرادات آخر 7 أيام -->
    <div class="row mt-3">
        <div class="col-12">
            <div class="chart-card">
                <h5 class="mb-2">📈 تحصيل الرسوم خلال آخر 7 أيام</h5>
                <canvas id="chartRevenue7"></canvas>
            </div>
        </div>
    </div>

    <hr class="text-secondary my-4">

    <!-- ==============================
         H) نشاط المستخدمين (يبقى أسفل الصفحة)
    =============================== -->
    <div class="card-box d-flex justify-content-between align-items-center">
        <div>
            <h5 class="mb-1">👨‍💻 نشاط المحاسبين / المستخدمين</h5>
            <p class="mb-0" style="font-size:13px;color:#9ca3af;">
                تتبع كل مستخدم: عدد الدفعات التي سجّلها، مجموع المبالغ، آخر عملية قام بها، وغيرها من التفاصيل.
            </p>
        </div>
        <a href="users_activity.php" class="btn btn-outline-info">
            عرض صفحة نشاط المستخدمين
        </a>
    </div>

</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// بيانات الأقسام
const collegesLabels = <?= json_encode(array_column($colleges, 'college_name')) ?>;
const collegesValues = <?= json_encode(array_map('intval', array_column($colleges, 'total'))) ?>;

// بيانات طرق الدفع
const ptLabels = <?= json_encode(array_column($paymentTypes, 'payment_type')) ?>;
const ptValues = <?= json_encode(array_map('intval', array_column($paymentTypes, 'total'))) ?>;

// بيانات آخر 7 أيام
const rev7Labels = <?= json_encode(array_column($rev7, 'd')) ?>;
const rev7Values = <?= json_encode(array_map('intval', array_column($rev7, 'total'))) ?>;

new Chart(document.getElementById("chartColleges"), {
    type:'bar',
    data:{
        labels:collegesLabels,
        datasets:[{
            label:"عدد الطلاب",
            data:collegesValues,
            backgroundColor:"#3b82f6"
        }]
    },
    options:{
        plugins:{ legend:{ display:false } },
        responsive:true,
        maintainAspectRatio:false
    }
});

new Chart(document.getElementById("chartPaymentTypes"), {
    type:'doughnut',
    data:{
        labels:ptLabels,
        datasets:[{
            data:ptValues,
            backgroundColor:["#22c55e","#3b82f6","#f97316","#e11d48","#a855f7"]
        }]
    },
    options:{
        plugins:{ legend:{ position:'bottom' } },
        responsive:true,
        maintainAspectRatio:false
    }
});

new Chart(document.getElementById("chartRevenue7"), {
    type:'line',
    data:{
        labels:rev7Labels,
        datasets:[{
            label:"الإيراد اليومي (د.ع)",
            data:rev7Values,
            tension:0.3,
            fill:false,
            borderColor:"#22c55e",
            pointRadius:4
        }]
    },
    options:{
        plugins:{ legend:{ display:false } },
        responsive:true,
        maintainAspectRatio:false,
        scales:{
            x:{ ticks:{ autoSkip:true, maxTicksLimit:7 } }
        }
    }
});
</script>

<?php require_once "includes/footer.php"; ?>