<?php
session_start();
if(!isset($_SESSION['finance_user'])){ header("Location: login.php"); exit; }

require_once "../config/db.php";
require_once "functions_accounts.php";
require_once "whatsapp.php";
require_once "../config/app.php";

$id = intval($_GET['id']);

// جلب بيانات الدفعة
$q = $conn->prepare("
    SELECT student_id, amount FROM payments WHERE id=?
");
$q->execute([$id]);
$p = $q->fetch(PDO::FETCH_ASSOC);

if(!$p){ die("Payment not found"); }

$student_id = $p['student_id'];

// حذف صورة الوصل
$img = $conn->prepare("SELECT receipt_image FROM payments WHERE id=?");
$img->execute([$id]);
$img_name = $img->fetchColumn();

if($img_name && file_exists("../uploads/receipts/$img_name")){
    unlink("../uploads/receipts/$img_name");
}

// حذف الدفعة
$del = $conn->prepare("DELETE FROM payments WHERE id=?");
$del->execute([$id]);

// تحديث الحساب
update_account($student_id);

// إشعار واتساب
$s = $conn->prepare("SELECT full_name, phone FROM students WHERE id=?");
$s->execute([$student_id]);
$st = $s->fetch(PDO::FETCH_ASSOC);

$message = "
⚠ تم حذف دفعة من حسابك

الاسم: {$st['full_name']}
المبلغ المحذوف: " . number_format($p['amount']) . "

للاستفسار يرجى مراجعة القسم المالي.
";

sendWhatsAppMessage($st['phone'], $message);

// إعادة التوجيه
header("Location: student_profile.php?id=$student_id");
exit;
?>