<?php
require_once "../config/db.php";
require_once "whatsapp.php";

if (!isset($_GET['id'])) die("Missing payment ID");

$payment_id = intval($_GET['id']);

$stmt = $conn->prepare("
    SELECT p.*, s.full_name, s.phone, s.college_name 
    FROM payments p 
    JOIN students s ON s.id = p.student_id
    WHERE p.id = :id
");
$stmt->execute([":id" => $payment_id]);
$payment = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$payment) die("Payment not found");

$student_id = $payment["student_id"];

if ($_SERVER['REQUEST_METHOD'] == "POST") {

    $amount         = intval($_POST['amount']);
    $payment_type   = $_POST['payment_type'];
    $receipt_number = $_POST['receipt_number'];
    $notes          = $_POST['notes'];

    $receipt_image = $payment["receipt_image"];

    if (!empty($_FILES["receipt_image"]["name"])) {

        $dir = "../uploads/receipts/";
        if (!file_exists($dir)) mkdir($dir, 0777, true);

        $ext  = pathinfo($_FILES["receipt_image"]["name"], PATHINFO_EXTENSION);
        $file = "receipt_" . uniqid() . "." . $ext;

        if (move_uploaded_file($_FILES["receipt_image"]["tmp_name"], $dir . $file)) {
            $receipt_image = $file;
        }
    }

    $update = $conn->prepare("
        UPDATE payments SET 
            amount = :amount,
            payment_type = :payment_type,
            receipt_number = :receipt_number,
            receipt_image = :receipt_image,
            notes = :notes
        WHERE id = :id
    ");

    $update->execute([
        ":amount"         => $amount,
        ":payment_type"   => $payment_type,
        ":receipt_number" => $receipt_number,
        ":receipt_image"  => $receipt_image,
        ":notes"          => $notes,
        ":id"             => $payment_id
    ]);

    $acc = $conn->query("SELECT * FROM accounts WHERE student_id = $student_id")->fetch(PDO::FETCH_ASSOC);

    $old_amount = $payment["amount"];
    $difference = $amount - $old_amount;

    $new_paid      = $acc["paid"] + $difference;
    $new_remaining = $acc["total_fee"] - $new_paid;

    $conn->prepare("UPDATE accounts SET paid = ?, remaining = ?, last_update = NOW() WHERE student_id = ?")
         ->execute([$new_paid, $new_remaining, $student_id]);

    $msg = "
🔄 *تم تعديل دفعة مالية*

👤 الطالب: *{$payment['full_name']}*
🏛 القسم: *{$payment['college_name']}*

💰 المبلغ الجديد: *$amount د.ع*
🧾 رقم الوصل: $receipt_number

📅 التاريخ: " . date("Y-m-d H:i") . "

نظام الحسابات – جامعة النبراس
";
    sendWhatsAppMessage($payment["phone"], $msg);

    header("Location: payments.php?updated=1");
    exit;
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>تعديل الدفعة</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

<style>
body {
    background: linear-gradient(135deg, #0f172a, #1e293b);
    font-family: Tajawal;
    color: white;
    padding: 40px;
}

.card-glass {
    background: rgba(255,255,255,0.05);
    border: 1px solid rgba(255,255,255,0.12);
    backdrop-filter: blur(14px);
    border-radius: 16px;
    padding: 30px;
    box-shadow: 0 10px 25px rgba(0,0,0,0.35);
    transition: .3s;
}
.card-glass:hover {
    transform: scale(1.01);
    box-shadow: 0 12px 30px rgba(0,0,0,0.45);
}

label { margin-top: 10px; font-weight: bold; }

.btn-submit {
    background: linear-gradient(135deg, #3b82f6, #6366f1);
    border: none;
    padding: 12px;
    font-size: 18px;
    border-radius: 10px;
}
.btn-submit:hover {
    filter: brightness(1.15);
}

.img-receipt {
    border-radius: 12px;
    border: 2px solid #3b82f6;
    margin-top: 10px;
}
</style>

</head>
<body>

<h2 class="mb-4">
    <i class="bi bi-pencil-square"></i> 
    تعديل الدفعة رقم <span style="color:#3b82f6;">#<?= $payment_id ?></span>
</h2>

<div class="card-glass">

<form method="POST" enctype="multipart/form-data">

    <div class="row">

        <div class="col-md-6">
            <label>اسم الطالب</label>
            <input type="text" class="form-control" value="<?= $payment['full_name'] ?>" disabled>
        </div>

        <div class="col-md-6">
            <label>المبلغ</label>
            <input type="number" name="amount" class="form-control" required value="<?= $payment['amount'] ?>">
        </div>

        <div class="col-md-6">
            <label>نوع الدفع</label>
            <select name="payment_type" class="form-select">
                <option <?= $payment['payment_type']=="نقدي"?"selected":"" ?>>نقدي</option>
                <option <?= $payment['payment_type']=="حوالة"?"selected":"" ?>>حوالة</option>
                <option <?= $payment['payment_type']=="إلكتروني"?"selected":"" ?>>إلكتروني</option>
                <option <?= $payment['payment_type']=="منحة"?"selected":"" ?>>منحة</option>
            </select>
        </div>

        <div class="col-md-6">
            <label>رقم الوصل</label>
            <input type="text" name="receipt_number" class="form-control" value="<?= $payment['receipt_number'] ?>">
        </div>

        <div class="col-md-12">
            <label>استبدال صورة الوصل (اختياري)</label>
            <input type="file" name="receipt_image" class="form-control">

            <?php if ($payment["receipt_image"]): ?>
                <img src="../uploads/receipts/<?= $payment['receipt_image'] ?>" width="250" class="img-receipt">
            <?php endif; ?>
        </div>

        <div class="col-md-12">
            <label>ملاحظات</label>
            <textarea name="notes" class="form-control" rows="3"><?= $payment["notes"] ?></textarea>
        </div>

    </div>

    <button class="btn-submit w-100 mt-4">
        <i class="bi bi-save"></i> حفظ التعديل
    </button>

</form>

</div>

</body>
</html>