<?php
session_start();
if(!isset($_SESSION['finance_user'])){ header("Location: login.php"); exit; }

require_once "../config/db.php";
require_once "functions_accounts.php";
require_once "whatsapp.php";
require_once "../config/app.php";

$id          = intval($_POST['id']);
$student_id  = intval($_POST['student_id']);
$amount      = intval($_POST['amount']);
$type        = $_POST['payment_type'];
$receipt     = $_POST['receipt_number'];
$note        = $_POST['note'];

// -------- صورة جديدة؟ --------
$img = null;

if(!empty($_FILES['new_image']['name'])){
    $ext = pathinfo($_FILES['new_image']['name'], PATHINFO_EXTENSION);
    $img = "receipt_" . uniqid() . "." . $ext;
    move_uploaded_file($_FILES['new_image']['tmp_name'], "../uploads/receipts/$img");

    // حذف القديم
    $old = $conn->prepare("SELECT receipt_image FROM payments WHERE id=?");
    $old->execute([$id]);
    $old_img = $old->fetchColumn();
    if($old_img && file_exists("../uploads/receipts/$old_img")){
        unlink("../uploads/receipts/$old_img");
    }
}

// -------- تحديث الدفعة --------
$q = $conn->prepare("
    UPDATE payments 
    SET amount=?, payment_type=?, receipt_number=?, note=?, 
        receipt_image = COALESCE(?, receipt_image)
    WHERE id=?
");

$q->execute([$amount, $type, $receipt, $note, $img, $id]);

// -------- تحديث الحساب --------
update_account($student_id);

// -------- بيانات الطالب --------
$st = $conn->prepare("SELECT full_name, phone FROM students WHERE id=?");
$st->execute([$student_id]);
$s = $st->fetch(PDO::FETCH_ASSOC);

// -------- رسالة واتساب --------
$message = "
تم تعديل إحدى دفعاتك ✔

الاسم: {$s['full_name']}
المبلغ الجديد: " . number_format($amount) . "
نوع الدفع: $type
رقم الوصل: $receipt

إذا لم تكن أنت من قام بالتعديل، يرجى مراجعة القسم المالي.
";

sendWhatsAppMessage($s['phone'], $message);

header("Location: view_payment.php?id=$id");
exit;
?>