<?php
require_once "../config/db.php";

require "../vendor/autoload.php";
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

/* ===========================
   1) استقبال الفلاتر
=========================== */
$name    = $_GET['name'] ?? "";
$college = $_GET['college'] ?? "";
$study   = $_GET['study'] ?? "";

/* ===========================
   2) جلب البيانات
=========================== */

$sql = "
    SELECT 
        s.full_name,
        s.college_name,
        s.study_type,
        s.phone,
        a.remaining,
        DATEDIFF(CURDATE(), a.due_date) AS days_late
    FROM accounts a
    JOIN students s ON s.id = a.student_id
    WHERE a.remaining > 0
      AND a.due_date IS NOT NULL
      AND a.due_date < CURDATE()
";

$params = [];

if ($name !== "") {
    $sql .= " AND s.full_name LIKE ? ";
    $params[] = "%$name%";
}
if ($college !== "") {
    $sql .= " AND s.college_name = ? ";
    $params[] = $college;
}
if ($study !== "") {
    $sql .= " AND s.study_type = ? ";
    $params[] = $study;
}

$sql .= " ORDER BY days_late DESC ";

$stmt = $conn->prepare($sql);
$stmt->execute($params);
$data = $stmt->fetchAll(PDO::FETCH_ASSOC);

/* ===========================
   3) إنشاء ملف Excel
=========================== */

$sheet = new Spreadsheet();
$sheet->getProperties()
      ->setCreator("Nebres University")
      ->setTitle("Late Payments Export");

$excel = $sheet->getActiveSheet();
$excel->setTitle("Late Students");

/* ===========================
   4) رأس الجدول
=========================== */

$headers = ["الطالب", "القسم", "الدراسة", "الهاتف", "المبلغ المتأخر", "الأيام"];

$col = "A";
foreach ($headers as $h) {
    $excel->setCellValue($col."1", $h);
    $excel->getStyle($col."1")->getFont()->setBold(true)->setSize(14);
    $excel->getStyle($col."1")->getAlignment()->setHorizontal('center');
    $col++;
}

/* ===========================
   5) تعبئة البيانات
=========================== */

$row = 2;
foreach ($data as $d) {
    $excel->setCellValue("A$row", $d['full_name']);
    $excel->setCellValue("B$row", $d['college_name']);
    $excel->setCellValue("C$row", $d['study_type']);
    $excel->setCellValue("D$row", $d['phone']);
    $excel->setCellValue("E$row", $d['remaining']);
    $excel->setCellValue("F$row", $d['days_late']);
    $row++;
}

/* تحسين العرض */
foreach (range('A','F') as $col) {
    $excel->getColumnDimension($col)->setAutoSize(true);
}

/* ===========================
   6) التحميل
=========================== */

header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
header("Content-Disposition: attachment; filename=late_students.xlsx");

$writer = new Xlsx($sheet);
$writer->save("php://output");
exit;