<?php
session_start();
if (!isset($_SESSION['finance_user'])) {
    header("Location: login.php");
    exit;
}

require_once "../config/db.php";
require_once "../config/whatsapp.php";
require_once "includes/header.php";
require_once "includes/navbar.php";

/* ============================================================
   1) الطلاب المتأخرين بالدفع
============================================================ */

$query = $conn->query("
    SELECT 
        s.id AS student_id,
        s.full_name,
        s.phone,
        s.college_name,
        s.study_type,
        a.id AS account_id,
        a.remaining,
        a.due_date,
        DATEDIFF(CURDATE(), a.due_date) AS days_late
    FROM accounts a
    JOIN students s ON s.id = a.student_id
    WHERE a.remaining > 0
      AND a.due_date IS NOT NULL
      AND a.due_date < CURDATE()
    ORDER BY days_late DESC
");

$late_students = $query->fetchAll(PDO::FETCH_ASSOC);
$total_late = count($late_students);

/* ============================================================
   2) إحصائيات الأقسام
============================================================ */

$department_stats = [];
$total_amount_late = 0;

foreach ($late_students as $ls) {
    $department_stats[$ls['college_name']] =
        ($department_stats[$ls['college_name']] ?? 0) + 1;

    $total_amount_late += $ls['remaining'];
}

$top_department = !empty($department_stats)
    ? array_search(max($department_stats), $department_stats)
    : "لا يوجد";

/* ============================================================
   3) الأقسام للدروب داون
============================================================ */

$colleges = $conn->query("
    SELECT DISTINCT college_name 
    FROM students 
    WHERE status='accepted'
    ORDER BY college_name ASC
")->fetchAll(PDO::FETCH_COLUMN);

/* ============================================================
   4) إرسال رسالة مفردة
============================================================ */

if (isset($_GET['send']) && isset($_GET['id'])) {

    $sid = intval($_GET['id']);
    $s = $conn->prepare("
        SELECT s.full_name, s.phone, a.remaining 
        FROM students s
        JOIN accounts a ON a.student_id = s.id
        WHERE s.id = ?
        LIMIT 1
    ");
    $s->execute([$sid]);
    $std = $s->fetch(PDO::FETCH_ASSOC);

    if ($std) {
        $msg = "
السلام عليكم

عزيزي الطالب (*{$std['full_name']}*)
نود إعلامكم بوجود قسط متأخر قدره (*" . number_format($std['remaining']) . " د.ع*)

يرجى مراجعة قسم الشؤون المالية خلال 48 ساعة لغرض التسديد
لتجنب إيقاف ملفك الدراسي.

جامعة النبراس – قسم الشؤون المالية
";
        sendWhatsAppMessage($std['phone'], $msg);
        header("Location: late_payments.php?sent_single=1");
        exit;
    }
}

/* ============================================================
   5) إرسال رسالة جماعية
============================================================ */

if (isset($_GET['send_all'])) {

    foreach ($late_students as $s) {

        $msg = "
السلام عليكم

عزيزي الطالب (*{$s['full_name']}*)
نود إعلامكم بوجود قسط متأخر قدره (*" . number_format($s['remaining']) . " د.ع*)

يرجى مراجعة قسم الشؤون المالية خلال 48 ساعة لغرض التسديد
لتجنب إيقاف ملفك الدراسي.

جامعة النبراس – قسم الشؤون المالية
";
        sendWhatsAppMessage($s['phone'], $msg);
    }

    header("Location: late_payments.php?sent_all=1");
    exit;
}

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8" />
<title>الطلاب المتأخرين بالدفع</title>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css">

<style>
body {
    background: #0f172a;
    color: white;
    font-family: 'Tajawal';
    padding-top: 0;
}

/* HEADER TITLE */
.page-title {
    font-size: 32px;
    font-weight: 800;
    background: linear-gradient(90deg,#818cf8,#a5b4fc);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

/* Dashboard-style Cards */
.stat-card {
    background: rgba(255,255,255,0.06);
    border-radius: 22px;
    padding: 25px;
    text-align: center;
    border: 1px solid rgba(255,255,255,0.08);
    backdrop-filter: blur(18px);
    box-shadow: 0 20px 40px rgba(0,0,0,0.4);
    transition: .25s;
}

.stat-card:hover {
    transform: translateY(-6px) scale(1.02);
    box-shadow: 0 30px 60px rgba(0,0,0,0.55);
}

.stat-icon {
    font-size: 32px;
    margin-bottom: 8px;
    color: #60a5fa;
}

.stat-number {
    font-size: 2.3rem;
    font-weight: 800;
    color: #38bdf8;
}

/* Apple Card */
.apple-card {
    background: rgba(255,255,255,0.07);
    border-radius: 30px;
    padding: 30px;
    border: 1px solid rgba(255,255,255,0.1);
    backdrop-filter: blur(18px);
    box-shadow: 0 22px 45px rgba(0,0,0,0.55);
}

/* Table */
.table-box {
    background: rgba(255,255,255,0.05);
    border-radius: 22px;
    overflow: hidden;
    border: 1px solid rgba(255,255,255,0.07);
}

.table thead {
    background: linear-gradient(90deg, #4f46e5, #6366f1);
    color: white;
}

/* Late Badge */
.badge-late {
    background: rgba(239,68,68,.25);
    color: #ef4444;
    padding: 6px 14px;
    border-radius: 10px;
    font-weight: bold;
}

/* Inputs */
.search-box input, .search-box select {
    background: rgba(255,255,255,0.08);
    border: 1px solid rgba(255,255,255,0.15);
    color: white;
}

/* Buttons */
.btn-apple {
    background: #6366f1;
    color: white;
    padding: 10px 25px;
    border-radius: 14px;
    font-weight: 700;
    transition: .25s;
}
.btn-apple:hover {
    background: #4f46e5;
    transform: translateY(-2px);
}
</style>

</head>
<body>

<div class="container">

    <!-- العنوان -->
    <h1 class="page-title mb-4">
        <i class="bi bi-exclamation-octagon"></i>
        الطلاب المتأخرين بالدفع
    </h1>

    <!-- كروت الإحصائيات -->
    <div class="row mb-4">

        <div class="col-md-3 mb-3">
            <div class="stat-card">
                <i class="bi bi-people-fill stat-icon"></i>
                <div class="stat-number"><?= $total_late ?></div>
                <div>عدد الطلاب المتأخرين</div>
            </div>
        </div>

        <div class="col-md-3 mb-3">
            <div class="stat-card">
                <i class="bi bi-building stat-icon"></i>
                <div class="stat-number"><?= count($department_stats) ?></div>
                <div>عدد الأقسام المتأخرة</div>
            </div>
        </div>

        <div class="col-md-3 mb-3">
            <div class="stat-card">
                <i class="bi bi-cash stat-icon"></i>
                <div class="stat-number"><?= number_format($total_amount_late) ?></div>
                <div>إجمالي المبالغ المتأخرة</div>
            </div>
        </div>

        <div class="col-md-3 mb-3">
            <div class="stat-card">
                <i class="bi bi-trophy stat-icon"></i>
                <div class="stat-number"><?= $top_department ?></div>
                <div>أكثر قسم فيه تأخير</div>
            </div>
        </div>

    </div>

    <!-- كارد العنوان -->
    <div class="apple-card mb-4 text-center">
        <h3 class="mb-3">
            <i class="bi bi-clock-history"></i> قوائم الطلاب المتأخرين
        </h3>

        <a href="late_payments.php?send_all=1" class="btn btn-apple">
            <i class="bi bi-whatsapp"></i> إرسال رسالة جماعية
        </a>

        <?php if(isset($_GET['sent_all'])): ?>
            <div class="alert alert-success mt-3">✔ تم إرسال الرسائل للجميع</div>
        <?php endif; ?>

        <?php if(isset($_GET['sent_single'])): ?>
            <div class="alert alert-success mt-3">✔ تم إرسال الرسالة للطالب</div>
        <?php endif; ?>
    </div>
<div class="d-flex gap-3 mb-3">

   <a href="late_payments_export_excel.php" class="btn btn-success mb-3">
    <i class="bi bi-file-earmark-excel"></i> تصدير Excel
</a>

    <a href="export_late_pdf.php?college=" 
       id="exportPDF"
       class="btn btn-danger fw-bold px-4">
        <i class="bi bi-filetype-pdf"></i> تصدير PDF
    </a>

</div>

<script>
/* تحديث رابط التصدير حسب الفلاتر */
function updateExportLinks() {

    const name       = document.getElementById("searchBox").value.trim();
    const college    = document.getElementById("filterCollege").value.trim();
    const study      = document.getElementById("filterStudy").value.trim();

    let baseExcel = "export_late_excel.php?";
    let basePDF   = "export_late_pdf.php?";

    baseExcel += "name="+encodeURIComponent(name)
              +"&college="+encodeURIComponent(college)
              +"&study="+encodeURIComponent(study);

    basePDF += "name="+encodeURIComponent(name)
              +"&college="+encodeURIComponent(college)
              +"&study="+encodeURIComponent(study);

    document.getElementById("exportExcel").href = baseExcel;
    document.getElementById("exportPDF").href   = basePDF;
}

/* تشغيل تحديث الروابط عند الفلترة */
document.getElementById("searchBox").onkeyup = updateExportLinks;
document.getElementById("filterCollege").onchange = updateExportLinks;
document.getElementById("filterStudy").onchange = updateExportLinks;

updateExportLinks();
</script>
    <!-- الفلاتر -->
    <div class="apple-card mb-4 search-box">
        <div class="row">

            <div class="col-md-4 mb-3">
                <label>بحث بالاسم</label>
                <input type="text" id="searchBox" class="form-control" placeholder="اكتب اسم الطالب">
            </div>

            <div class="col-md-4 mb-3">
                <label>القسم</label>
                <select id="filterCollege" class="form-select">
                    <option value="">الكل</option>
                    <?php foreach($colleges as $c): ?>
                        <option><?= $c ?></option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="col-md-4 mb-3">
                <label>نوع الدراسة</label>
                <select id="filterStudy" class="form-select">
                    <option value="">الكل</option>
                    <option>صباحي</option>
                    <option>مسائي</option>
                </select>
            </div>

        </div>
    </div>

    <!-- الجدول -->
    <div class="table-box">
        <table class="table table-hover text-center mb-0" id="lateTable">
            <thead>
                <tr>
                    <th>#</th>
                    <th>الطالب</th>
                    <th>القسم</th>
                    <th>الدراسة</th>
                    <th>الهاتف</th>
                    <th>المبلغ</th>
                    <th>الأيام</th>
                    <th>إرسال</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach($late_students as $i => $s): ?>
                <tr>
                    <td><?= $i+1 ?></td>
                    <td><?= $s['full_name'] ?></td>
                    <td><?= $s['college_name'] ?></td>
                    <td><?= $s['study_type'] ?></td>
                    <td><?= $s['phone'] ?></td>
                    <td class="text-danger fw-bold"><?= number_format($s['remaining']) ?></td>
                    <td>
                        <span class="badge-late"><?= $s['days_late'] ?> يوم</span>
                    </td>
                    <td>
                        <a href="late_payments.php?send=1&id=<?= $s['student_id'] ?>" 
                           class="btn btn-success btn-sm">
                           <i class="bi bi-whatsapp"></i>
                        </a>
                    </td>
                </tr>
            <?php endforeach;?>
            </tbody>
        </table>
    </div>

</div>

<script>
/* فلترة الجدول داخل الصفحة */
const rows = document.querySelectorAll("#lateTable tbody tr");

document.getElementById("searchBox").addEventListener("keyup", filter);
document.getElementById("filterCollege").addEventListener("change", filter);
document.getElementById("filterStudy").addEventListener("change", filter);

function filter(){
    let name = searchBox.value.trim();
    let college = filterCollege.value.trim();
    let study = filterStudy.value.trim();

    rows.forEach(r => {
        let ok = true;

        if (name && !r.children[1].innerText.includes(name)) ok = false;
        if (college && r.children[2].innerText.trim() !== college) ok = false;
        if (study && r.children[3].innerText.trim() !== study) ok = false;

        r.style.display = ok ? "" : "none";
    });
}
</script>

</body>
</html>