<?php
session_start();
if (!isset($_SESSION['finance_user'])) {
    header("Location: login.php");
    exit;
}

require_once "../config/db.php";

/*
==============================================================
📌 جلب المتأخرين في الدفع
==============================================================
*/
$query = $conn->query("
    SELECT 
        s.id AS student_id,
        s.full_name,
        s.phone,
        s.college_name,
        s.study_type,
        a.remaining,
        a.due_date,
        DATEDIFF(CURDATE(), a.due_date) AS days_late
    FROM accounts a
    JOIN students s ON s.id = a.student_id
    WHERE a.remaining > 0
      AND a.due_date IS NOT NULL
      AND a.due_date < CURDATE()
    ORDER BY days_late DESC
");

$rows = $query->fetchAll(PDO::FETCH_ASSOC);

/*
==============================================================
📌 إعداد ملف Excel (XML Spreadsheet)
==============================================================
*/

// اسم الملف مع التاريخ
$filename = "Late_Payments_" . date("Y-m-d") . ".xls";

// هيدر التحميل
header("Content-Type: application/vnd.ms-excel; charset=utf-8");
header("Content-Disposition: attachment; filename=\"$filename\"");
header("Cache-Control: max-age=0");

// فتح XML
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
?>
<Workbook xmlns="urn:schemas-microsoft-com:office:spreadsheet"
 xmlns:o="urn:schemas-microsoft-com:office:office"
 xmlns:x="urn:schemas-microsoft-com:office:excel"
 xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet">

    <Worksheet ss:Name="Late Students">
        <Table>

            <!-- رؤوس الجدول -->
            <Row>
                <Cell><Data ss:Type="String">#</Data></Cell>
                <Cell><Data ss:Type="String">اسم الطالب</Data></Cell>
                <Cell><Data ss:Type="String">القسم</Data></Cell>
                <Cell><Data ss:Type="String">نوع الدراسة</Data></Cell>
                <Cell><Data ss:Type="String">الهاتف</Data></Cell>
                <Cell><Data ss:Type="String">المبلغ المتأخر</Data></Cell>
                <Cell><Data ss:Type="String">الأيام المتأخرة</Data></Cell>
                <Cell><Data ss:Type="String">تاريخ الاستحقاق</Data></Cell>
            </Row>

            <?php 
            $i = 1;
            foreach ($rows as $r): 
            ?>

            <Row>
                <Cell><Data ss:Type="Number"><?= $i ?></Data></Cell>
                <Cell><Data ss:Type="String"><?= htmlspecialchars($r['full_name']) ?></Data></Cell>
                <Cell><Data ss:Type="String"><?= htmlspecialchars($r['college_name']) ?></Data></Cell>
                <Cell><Data ss:Type="String"><?= htmlspecialchars($r['study_type']) ?></Data></Cell>
                <Cell><Data ss:Type="String"><?= htmlspecialchars($r['phone']) ?></Data></Cell>
                <Cell><Data ss:Type="Number"><?= $r['remaining'] ?></Data></Cell>
                <Cell><Data ss:Type="Number"><?= $r['days_late'] ?></Data></Cell>
                <Cell><Data ss:Type="String"><?= $r['due_date'] ?></Data></Cell>
            </Row>

            <?php 
            $i++;
            endforeach; 
            ?>

        </Table>
    </Worksheet>
</Workbook>