<?php
require_once "../config/db.php";
require_once "includes/navbar.php";
require_once "../config/app.php";
require_once "includes/header.php";
// جلب كل الطلاب مع دمج الدفعات — كل طالب مرة واحدة فقط
$students = $conn->query("
    SELECT 
        s.id AS sid,
        s.full_name,
        COUNT(p.id) AS payments_count,
        COALESCE(SUM(p.amount),0) AS total_paid,
        MAX(p.paid_at) AS last_payment
    FROM students s
    LEFT JOIN payments p ON p.student_id = s.id
    WHERE s.status='accepted'
    GROUP BY s.id
    ORDER BY total_paid DESC
")->fetchAll(PDO::FETCH_ASSOC);

// حساب ملفات الأرشيف لكل طالب
$files_count = [];
$base_dir = "../uploads/archive/";

foreach (glob($base_dir . "student_*") as $folder) {
    $id = str_replace("student_", "", basename($folder));
    $files_count[$id] = count(glob("$folder/*"));
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>📁 أرشيف النظام المالي</title>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css">

<style>
body{
    background: linear-gradient(135deg,#0e1528,#111b34);
    font-family:"Tajawal";
    color:white;
    padding-top:0;
}
.glass-box {
    background: rgba(255,255,255,0.05);
    padding:25px;
    border-radius:20px;
    border:1px solid rgba(255,255,255,0.12);
    backdrop-filter: blur(14px);
    box-shadow:0 10px 40px rgba(0,0,0,0.7);
    margin-top:20px;
}

.student-card {
    background: rgba(255,255,255,0.08);
    border-radius: 16px;
    padding: 18px 22px;
    margin-bottom: 15px;
    border:1px solid rgba(255,255,255,0.15);
    transition: .3s;
}
.student-card:hover {
    transform:scale(1.02);
    background: rgba(255,255,255,0.13);
}

.open-btn {
    background:linear-gradient(90deg,#4f46e5,#7c3aed);
    border:0;
    color:white;
    padding:8px 18px;
    border-radius:12px;
    font-weight:700;
    transition:.3s;
}
.open-btn:hover{
    opacity:0.85;
}

.badge-files{
    background:#22c55e;
    padding:5px 10px;
    border-radius:30px;
    font-size:13px;
}

.amount{
    font-size:18px;
    font-weight:900;
    color:#4ade80;
}
</style>
</head>

<body>

<div class="container">

    <div class="glass-box">

        <h2 class="mb-4">
            <i class="bi bi-archive"></i>
            أرشيف النظام المالي — الطلاب
        </h2>

        <?php foreach($students as $st): ?>
        <div class="student-card row align-items-center">

            <div class="col-md-4">
                <h5 class="fw-bold"><?= $st['full_name'] ?></h5>
                <span class="badge-files">
                    <?= $files_count[$st['sid']] ?? 0 ?> ملفات أرشيف
                </span>
            </div>

            <div class="col-md-2 text-center">
                <div class="amount"><?= number_format($st['total_paid']) ?></div>
                <small>إجمالي المدفوع</small>
            </div>

            <div class="col-md-2 text-center">
                <div class="fw-bold"><?= $st['payments_count'] ?></div>
                <small>عدد الدفعات</small>
            </div>

            <div class="col-md-3 text-center">
                <div>
                    <?= $st['last_payment'] ?: "—" ?>
                </div>
                <small>آخر دفعة</small>
            </div>

            <div class="col-md-1 text-center">
                <a href="student_archive.php?id=<?= $st['sid'] ?>" class="open-btn">
                    فتح
                </a>
            </div>

        </div>
        <?php endforeach; ?>

        <?php if (count($students) == 0): ?>
            <div class="alert alert-info text-dark">لا يوجد طلاب.</div>
        <?php endif; ?>

    </div>

</div>

</body>
</html>