<?php
session_start();
require_once "../config/db.php";

if (!isset($_GET["id"])) {
    die("❌ رقم الدفعة غير موجود");
}

$payment_id = intval($_GET["id"]);

/* =======================================================
   جلب بيانات الدفعة + الطالب + الموظف
======================================================= */
$q = $conn->prepare("
    SELECT 
        p.*,
        s.full_name,
        s.college_name,
        s.study_type,
        s.phone,
        fu.name AS staff_name
    FROM payments p
    JOIN students s ON s.id = p.student_id
    LEFT JOIN finance_users fu ON fu.id = p.finance_user_id
    WHERE p.id = ?
    LIMIT 1
");
$q->execute([$payment_id]);
$data = $q->fetch(PDO::FETCH_ASSOC);

if (!$data) die("❌ الدفعة غير موجودة");

/* =======================================================
   تجهيز التاريخ واسم اليوم
======================================================= */
$days = [
    "Monday"    => "الاثنين",
    "Tuesday"   => "الثلاثاء",
    "Wednesday" => "الأربعاء",
    "Thursday"  => "الخميس",
    "Friday"    => "الجمعة",
    "Saturday"  => "السبت",
    "Sunday"    => "الأحد"
];

$day_en  = date("l", strtotime($data["paid_at"]));
$day_ar  = $days[$day_en] ?? "";
$date_ar = date("Y-m-d", strtotime($data["paid_at"]));
$time_ar = date("h:i A", strtotime($data["paid_at"]));

/* =======================================================
   mpdf
======================================================= */
require_once "../vendor/autoload.php";

$mpdf = new \Mpdf\Mpdf([
    'mode' => 'utf-8',
    'format' => 'A4',
    'margin_top' => 15,
    'margin_bottom' => 15,
    'margin_left' => 15,
    'margin_right' => 15
]);

$logo_path = "../assets/img/logo.png"; // ← مسار الشعار

/* =======================================================
   HTML التصميم الرسمي
======================================================= */
$html = '
<style>
body { font-family: "Tahoma"; direction: rtl; }

.box {
    border: 2px solid #000;
    padding: 15px;
    margin-top: 10px;
    border-radius: 8px;
}

table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 15px;
}

td {
    padding: 8px;
    font-size: 16px;
}

.title {
    text-align: center;
    font-size: 22px;
    margin-top: 5px;
    font-weight: bold;
}

.sub {
    text-align: center; 
    font-size: 14px;
    color: #444;
}

.label { font-weight: bold; }
</style>

<!-- الشعار -->
<div style="text-align:center;">
    <img src="'.$logo_path.'" width="120">
</div>

<div class="title">وصل تسديد أجور دراسية</div>
<div class="sub">جامعة النبراس – شعبة الحسابات</div>

<div class="box">

<table border="0">
<tr>
    <td class="label">اسم الطالب:</td>
    <td>'.$data["full_name"].'</td>
</tr>

<tr>
    <td class="label">القسم:</td>
    <td>'.$data["college_name"].'</td>
</tr>

<tr>
    <td class="label">نوع الدراسة:</td>
    <td>'.$data["study_type"].'</td>
</tr>

<tr>
    <td class="label">رقم الهاتف:</td>
    <td>'.$data["phone"].'</td>
</tr>

<tr>
    <td class="label">رقم الوصل:</td>
    <td>'.$data["receipt_number"].'</td>
</tr>

<tr>
    <td class="label">نوع الدفع:</td>
    <td>'.$data["payment_type"].'</td>
</tr>

<tr>
    <td class="label">المبلغ المدفوع:</td>
    <td>'.number_format($data["amount"]).' د.ع</td>
</tr>

<tr>
    <td class="label">التاريخ:</td>
    <td>'.$date_ar.' – '.$day_ar.' – '.$time_ar.'</td>
</tr>

<tr>
    <td class="label">الموظف الذي قام بالإجراء:</td>
    <td>'.($data["staff_name"] ?: "غير مسجل").'</td>
</tr>

</table>

</div>

<div style="margin-top:40px; text-align:center; font-size:14px;">
    تم إنشاء هذا الوصل عبر النظام المالي – جامعة النبراس
</div>
';

/* =======================================================
   إخراج PDF بدون حفظ في السيرفر
======================================================= */
$mpdf->WriteHTML($html);
$mpdf->Output("payment_receipt_{$payment_id}.pdf","I"); // عرض مباشر بدون تخزين