<?php
require_once "../config/db.php";
require_once __DIR__."/../libs/mpdf/vendor/autoload.php";
require_once "../config/app.php";

$id = intval($_GET['id']);

$payment = $conn->query("
    SELECT p.*, s.full_name, s.college_name, s.study_type
    FROM payments p 
    JOIN students s ON s.id=p.student_id
    WHERE p.id=$id
")->fetch(PDO::FETCH_ASSOC);

if (!$payment) die("غير موجود");

$mpdf = new \Mpdf\Mpdf(['rtl'=>true,'default_font'=>'dejavusans']);

$logo = "../assets/img/logo.png";

$html = "
<div style='text-align:center'>
    <img src='$logo' style='width:100px;'>
    <h2>وصل استلام رسمي</h2>
    <hr>
</div>

<h3>👤 بيانات الطالب</h3>
<b>الاسم:</b> {$payment['full_name']}<br>
<b>القسم:</b> {$payment['college_name']} – {$payment['study_type']}<br>

<h3>💰 تفاصيل الدفعة</h3>
<b>المبلغ:</b> ".number_format($payment['amount'])." دينار<br>
<b>نوع الدفع:</b> {$payment['payment_type']}<br>
<b>رقم الوصل:</b> {$payment['receipt_number']}<br>
<b>التاريخ:</b> {$payment['paid_at']}<br>

<br>

<div style='text-align:center'>
    <qrcode value='{$payment['receipt_number']}' size='80'></qrcode>
</div>

<br><hr><br>
<div style='text-align:left;'>
توقيع المحاسب: ______________________
</div>
";

$mpdf->WriteHTML($html);
$mpdf->Output("receipt_{$payment['id']}.pdf","I");