<?php
session_start();
if (!isset($_SESSION['finance_user'])) {
    header("Location: login.php");
    exit;
}

require_once "../config/db.php";
require_once "../config/app.php";
require_once "includes/header.php";
require_once "includes/navbar.php";

// ====================================================
// جلب بيانات الطالب
// ====================================================
$student_id = intval($_GET["id"] ?? 0);
if ($student_id <= 0) die("❌ Student ID missing");

$student = $conn->prepare("SELECT * FROM students WHERE id=? LIMIT 1");
$student->execute([$student_id]);
$student = $student->fetch(PDO::FETCH_ASSOC);

if (!$student) die("❌ Student not found");

// ====================================================
// إعداد مجلد الأرشيف
// ====================================================
$archive_dir = "../uploads/archive/student_" . $student_id . "/";
if (!is_dir($archive_dir)) {
    mkdir($archive_dir, 0777, true);
    chmod($archive_dir, 0777);
}
$archive_files = glob($archive_dir . "*");

// ====================================================
// جلب الدفعات
// ====================================================
$payments = $conn->prepare("
    SELECT *
    FROM payments
    WHERE student_id=?
    ORDER BY paid_at DESC
");
$payments->execute([$student_id]);
$payments = $payments->fetchAll(PDO::FETCH_ASSOC);

// ====================================================
// ملف PDF
// ====================================================
$pdf_path = "../uploads/pdfs/{$student_id}.pdf";
$pdf_exists = file_exists($pdf_path);

// ====================================================
// صورة الطالب
// ====================================================
$photo_path = "../uploads/students/personal_photos/profile_pic_{$student_id}.jpg";
$photo_exists = file_exists($photo_path);
?>

<style>
body{
    background:#0f172a;
    color:white;
    font-family:"Tajawal",sans-serif;
}

/* Apple Glass Box */
.glass-box{
    background:rgba(255,255,255,0.05);
    backdrop-filter:blur(14px);
    padding:25px;
    border-radius:22px;
    border:1px solid rgba(255,255,255,0.12);
    box-shadow:0 10px 40px rgba(0,0,0,0.6);
    margin-top:25px;
}

/* Tabs */
.nav-tabs .nav-link{
    background:rgba(255,255,255,0.15);
    border:0;
    border-radius:12px;
    margin-right:8px;
    color:#e2e8f0;
    font-weight:600;
}
.nav-tabs .nav-link.active{
    background:#3b82f6 !important;
    color:white !important;
}

/* Payment Row */
.pay-row{
    background:rgba(255,255,255,0.08);
    border:1px solid rgba(255,255,255,0.18);
    padding:12px 18px;
    border-radius:14px;
    margin-bottom:12px;
    display:flex;
    align-items:center;
    justify-content:space-between;
    transition:.2s;
}
.pay-row:hover{ transform:scale(1.02); }

.thumb-img{
    width:140px;
    border-radius:12px;
    cursor:pointer;
}

.file-card{
    background:rgba(255,255,255,0.08);
    padding:12px;
    border-radius:16px;
    margin-bottom:12px;
    border:1px solid rgba(255,255,255,0.12);
}
</style>


<div class="container">

    <div class="glass-box">

        <h2 class="mb-3">
            <i class="bi bi-archive"></i>
            أرشيف الطالب: <?= htmlspecialchars($student["full_name"]) ?>
        </h2>

        <!-- Tabs -->
        <ul class="nav nav-tabs mt-3">
            <li class="nav-item"><a class="nav-link active" data-bs-toggle="tab" href="#t1">الدفعات</a></li>
            <li class="nav-item"><a class="nav-link" data-bs-toggle="tab" href="#t2">الوصولات والصور</a></li>
            <li class="nav-item"><a class="nav-link" data-bs-toggle="tab" href="#t3">PDF الرسمي</a></li>
            <li class="nav-item"><a class="nav-link" data-bs-toggle="tab" href="#t4">ملفات إضافية</a></li>
        </ul>

        <div class="tab-content mt-4">

            <!-- TAB 1 — الدفعات -->
            <div class="tab-pane fade show active" id="t1">

                <?php if (!$payments): ?>
                    <div class="alert alert-info">لا توجد دفعات بعد.</div>
                <?php endif; ?>

                <?php foreach($payments as $p): ?>
                <div class="pay-row">

                    <!-- معلومات الدفع -->
                    <div>
                        <div class="fw-bold text-success fs-5">
                            <?= number_format($p["amount"]) ?> د.ع
                        </div>
                        <small>رقم الوصل: <?= $p["receipt_number"] ?: "—" ?></small><br>
                        <small>نوع الدفع: <?= $p["payment_type"] ?></small><br>
                        <small>التاريخ: <?= $p["paid_at"] ?></small>
                    </div>

                    <!-- ملاحظات -->
                    <?php if($p["notes"]): ?>
                    <div class="text-warning">
                        <small><b>ملاحظة:</b> <?= htmlspecialchars($p["notes"]) ?></small>
                    </div>
                    <?php endif; ?>

                    <!-- صورة الوصل -->
                    <?php if($p["receipt_image"]): ?>
                        <div>
                            <img src="../uploads/receipts/<?= $p['receipt_image'] ?>"
                                 class="thumb-img"
                                 data-img="<?= $p['receipt_image'] ?>"
                                 onclick="openImageModal(this)">
                        </div>
                    <?php endif; ?>

                </div>
                <?php endforeach; ?>

            </div>

            <!-- TAB 2 — الصور والوصولات -->
            <div class="tab-pane fade" id="t2">

                <?php if ($photo_exists): ?>
                    <div class="file-card">
                        <h5>📌 صورة الطالب</h5>
                        <img src="<?= $photo_path ?>" class="thumb-img mt-2"
                             data-img="<?= basename($photo_path) ?>"
                             onclick="openImageModal(this)">
                    </div>
                <?php endif; ?>

                <h5 class="mt-3">📂 ملفات الأرشيف</h5>

                <?php if (!$archive_files): ?>
                    <div class="alert alert-warning">لا يوجد ملفات.</div>
                <?php endif; ?>

                <?php foreach($archive_files as $file): ?>
                    <?php $fname = basename($file); ?>
                    <div class="file-card">
                        <b><?= $fname ?></b><br>

                        <?php if(preg_match("/\.(jpg|jpeg|png|webp)$/i",$fname)): ?>
                        <img src="<?= $file ?>" class="thumb-img mt-2"
                             data-img="<?= $fname ?>"
                             onclick="openImageModal(this)">
                        <?php endif; ?>

                        <a href="<?= $file ?>" download class="btn btn-primary btn-sm mt-2">تحميل</a>
                    </div>
                <?php endforeach; ?>

                <!-- رفع ملف -->
                <form method="POST" action="upload_archive.php"
                      enctype="multipart/form-data" class="mt-4">
                    <input type="hidden" name="student_id" value="<?= $student_id ?>">
                    <input type="file" class="form-control mb-2" name="file" required>
                    <button class="btn btn-success w-100">رفع ملف جديد</button>
                </form>

            </div>

            <!-- TAB 3 — PDF -->
            <div class="tab-pane fade" id="t3">
                <?php if(!$pdf_exists): ?>
                    <div class="alert alert-warning">لم يتم إنشاء PDF بعد.</div>
                <?php else: ?>
                    <iframe src="<?= $pdf_path ?>" style="width:100%;height:500px;border-radius:12px;"></iframe>
                    <a href="<?= $pdf_path ?>" download class="btn btn-primary w-100 mt-3">تحميل PDF</a>
                <?php endif; ?>
            </div>

            <!-- TAB 4 — ملفات إضافية -->
            <div class="tab-pane fade" id="t4">
                <?php foreach($archive_files as $file): ?>
                <div class="file-card">
                    <?= basename($file) ?>
                    <a href="<?= $file ?>" download class="btn btn-secondary btn-sm mt-2">تحميل</a>
                </div>
                <?php endforeach; ?>
            </div>

        </div>

        <a href="zip_archive.php?id=<?= $student_id ?>" 
   target="_blank"
   class="btn btn-success w-100 py-3 fs-5 fw-bold">
   <i class="bi bi-download"></i> إنشاء ملف ZIP شامل
</a>


    </div>

</div>

<!-- ============================= -->
<!-- Global Image Modal -->
<!-- ============================= -->
<div class="modal fade" id="globalImageModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content bg-dark text-white" 
         style="border-radius:16px; background:rgba(0,0,0,0.85); backdrop-filter:blur(8px); border:0;">
      
      <div class="modal-header border-0">
        <h5 class="modal-title">🧾 صورة الوصل</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      
      <div class="modal-body text-center">
        <img id="modalImage" src="" style="
            max-width:100%;
            max-height:70vh;
            border-radius:14px;
            object-fit:contain;
        ">
      </div>

      <div class="modal-footer border-0 justify-content-center">
        <a id="downloadImage" href="#" download class="btn btn-light fw-bold px-4">تحميل</a>
        <button type="button" class="btn btn-secondary fw-bold px-4" data-bs-dismiss="modal">إغلاق</button>
      </div>

    </div>
  </div>
</div>

<script>
function openImageModal(el){
    let file = el.getAttribute("data-img");

    document.getElementById("modalImage").src = 
        (file.includes("profile_pic") ? "../uploads/students/personal_photos/" : "../uploads/receipts/") 
        + file;

    document.getElementById("downloadImage").href = 
        (file.includes("profile_pic") ? "../uploads/students/personal_photos/" : "../uploads/receipts/") 
        + file;

    let modal = new bootstrap.Modal(document.getElementById('globalImageModal'));
    modal.show();
}
</script>

<?php require_once "includes/footer.php"; ?>