<?php
session_start();
if (!isset($_SESSION['finance_user'])) {
    header("Location: login.php");
    exit;
}

require_once "../config/db.php";
require_once "includes/header.php";
require_once "includes/navbar.php";
require_once "../config/app.php";

/* ===========================
   جلب بيانات الطلاب المقبولين
=========================== */
$students = $conn->query("
    SELECT s.*, a.total_fee, a.paid, a.remaining
    FROM students s
    LEFT JOIN accounts a ON a.student_id = s.id
    WHERE s.status='accepted'
    ORDER BY s.id DESC
")->fetchAll(PDO::FETCH_ASSOC);

/* ===========================
   عدادات عامة
=========================== */
$total_students = count($students);

$sum_total = 0;
$sum_paid  = 0;
$sum_rem   = 0;

$male   = 0;
$female = 0;

$day   = 0;
$night = 0;

foreach ($students as $s) {
    $sum_total += (int)$s['total_fee'];
    $sum_paid  += (int)$s['paid'];
    $sum_rem   += (int)$s['remaining'];

    if ($s['gender'] == "ذكر")  $male++;
    if ($s['gender'] == "أنثى") $female++;

    if ($s['study_type'] == "صباحي") $day++;
    else $night++;
}

function safe($v) {
    return $v === null ? "0" : number_format($v);
}
?>

<style>
body{
    background:#0f172a;
    color:#fff;
    font-family:"Tajawal",sans-serif;
}

/* ===== Vision Pro Floating Cards ===== */
.vp-card{
    background:rgba(255,255,255,0.07);
    backdrop-filter:blur(18px);
    border-radius:20px;
    border:1px solid rgba(255,255,255,0.12);
    padding:22px;
    box-shadow:0 8px 32px rgba(0,0,0,0.35);
    transition:.25s;
}
.vp-card:hover{
    transform:translateY(-4px);
    box-shadow:0 12px 45px rgba(0,0,0,0.5);
}

.stat-icon{
    font-size:32px;
    opacity:.9;
}
.stat-num{
    font-size:26px;
    font-weight:900;
}

/* Filter Box */
.filter-box{
    background:rgba(15,23,42,0.65);
    border-radius:20px;
    backdrop-filter:blur(12px);
    padding:20px;
    border:1px solid rgba(255,255,255,0.12);
}
.filter-box input,
.filter-box select{
    background:rgba(255,255,255,0.08);
    border:1px solid rgba(255,255,255,0.12);
    color:white;
    border-radius:12px;
}

/* Table */
.vp-table thead{
    background:rgba(255,255,255,0.15);
    backdrop-filter:blur(12px);
    color:#fff;
    font-weight:bold;
}
.vp-table tbody tr:hover{
    background:rgba(255,255,255,0.08) !important;
}

/* CSV Button */
.csv-btn{
    background:#3b82f6;
    color:white;
    padding:10px 20px;
    border:none;
    border-radius:12px;
    transition:.2s;
}
.csv-btn:hover{ background:#2563eb; }

/* Folder Button */
.folder-btn{
    background:#10b981;
    border:none;
    padding:6px 12px;
    border-radius:10px;
    color:white;
    font-weight:700;
    transition:.2s;
}
.folder-btn:hover{ background:#059669; }
</style>

<div class="container mt-4">

    <h2 class="mb-4"><i class="bi bi-people-fill"></i> لوحة الطلاب المقبولين</h2>

    <!-- ====== إحصائيات عامة ====== -->
    <div class="row mb-4">

        <div class="col-md-3 mb-3">
            <div class="vp-card text-center">
                <div class="stat-icon text-info"><i class="bi bi-people-fill"></i></div>
                <h5>عدد الطلاب</h5>
                <div class="stat-num"><?= $total_students ?></div>
            </div>
        </div>

        <div class="col-md-3 mb-3">
            <div class="vp-card text-center">
                <div class="stat-icon text-success"><i class="bi bi-cash-stack"></i></div>
                <h5>المجموع الكلي</h5>
                <div class="stat-num"><?= safe($sum_total) ?> د.ع</div>
            </div>
        </div>

        <div class="col-md-3 mb-3">
            <div class="vp-card text-center">
                <div class="stat-icon text-primary"><i class="bi bi-wallet2"></i></div>
                <h5>المدفوع</h5>
                <div class="stat-num"><?= safe($sum_paid) ?> د.ع</div>
            </div>
        </div>

        <div class="col-md-3 mb-3">
            <div class="vp-card text-center">
                <div class="stat-icon text-danger"><i class="bi bi-exclamation-triangle"></i></div>
                <h5>المتبقي</h5>
                <div class="stat-num"><?= safe($sum_rem) ?> د.ع</div>
            </div>
        </div>

    </div>

    <!-- ====== إحصائيات صغرى (اختيارية) ====== -->
    <div class="row mb-4">
        <div class="col-md-3 mb-3">
            <div class="vp-card text-center">
                <div class="stat-icon text-warning"><i class="bi bi-brightness-high"></i></div>
                <h6>الصباحي</h6>
                <div class="stat-num"><?= $day ?></div>
            </div>
        </div>

        <div class="col-md-3 mb-3">
            <div class="vp-card text-center">
                <div class="stat-icon text-light"><i class="bi bi-moon"></i></div>
                <h6>المسائي</h6>
                <div class="stat-num"><?= $night ?></div>
            </div>
        </div>

        <div class="col-md-3 mb-3">
            <div class="vp-card text-center">
                <div class="stat-icon text-info"><i class="bi bi-gender-male"></i></div>
                <h6>الذكور</h6>
                <div class="stat-num"><?= $male ?></div>
            </div>
        </div>

        <div class="col-md-3 mb-3">
            <div class="vp-card text-center">
                <div class="stat-icon" style="color:#f472b6;"><i class="bi bi-gender-female"></i></div>
                <h6>الإناث</h6>
                <div class="stat-num"><?= $female ?></div>
            </div>
        </div>
    </div>

    <!-- ====== الفلاتر المتقدمة ====== -->
    <div class="filter-box mb-4">

        <h4 class="mb-3"><i class="bi bi-funnel"></i> الفلاتر المتقدمة</h4>

        <div class="row g-3">

            <div class="col-md-3">
                <label class="form-label">بحث عام</label>
                <input type="text" class="form-control" id="search" placeholder="اسم / قسم / هاتف / رقم">
            </div>

            <div class="col-md-3">
                <label class="form-label">القسم</label>
                <select class="form-select" id="filter_college">
                    <option value="">الكل</option>
                    <?php
                    $cols = $conn->query("
                        SELECT DISTINCT college_name 
                        FROM students 
                        WHERE status='accepted' AND college_name IS NOT NULL AND college_name <> ''
                    ")->fetchAll(PDO::FETCH_COLUMN);
                    foreach ($cols as $c): ?>
                        <option><?= htmlspecialchars($c) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="col-md-3">
                <label class="form-label">نوع الدراسة</label>
                <select class="form-select" id="filter_study">
                    <option value="">الكل</option>
                    <option value="صباحي">صباحي</option>
                    <option value="مسائي">مسائي</option>
                </select>
            </div>

            <div class="col-md-3">
                <label class="form-label">الجنس</label>
                <select class="form-select" id="filter_gender">
                    <option value="">الكل</option>
                    <option value="ذكر">ذكر</option>
                    <option value="أنثى">أنثى</option>
                </select>
            </div>

        </div>

        <button class="csv-btn mt-3" id="exportCSV">
            <i class="bi bi-filetype-csv"></i> تصدير CSV (حسب الفلترة)
        </button>

    </div>

    <!-- ====== جدول الطلاب ====== -->
    <div class="vp-card">

        <table class="table table-dark table-hover text-center align-middle vp-table" id="studentsTable">
            <thead>
                <tr>
                    <th>#</th>
                    <th>الاسم</th>
                    <th>القسم</th>
                    <th>الدراسة</th>
                    <th>الجنس</th>
                    <th>الهاتف</th>
                    <th>الكلي</th>
                    <th>المدفوع</th>
                    <th>المتبقي</th>
                    <th>ملف</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($students as $s): ?>
                <tr>
                    <td><?= $s['id'] ?></td>
                    <td><?= htmlspecialchars($s['full_name']) ?></td>
                    <td><?= htmlspecialchars($s['college_name']) ?></td>
                    <td><?= htmlspecialchars($s['study_type']) ?></td>
                    <td><?= htmlspecialchars($s['gender']) ?></td>
                    <td><?= htmlspecialchars($s['phone']) ?></td>
                    <td><?= safe($s['total_fee']) ?></td>
                    <td class="text-success fw-bold"><?= safe($s['paid']) ?></td>
                    <td class="text-danger fw-bold"><?= safe($s['remaining']) ?></td>
                    <td>
                        <a href="student_profile.php?id=<?= $s['id'] ?>" class="folder-btn" title="فتح ملف الطالب">
                            <i class="bi bi-folder2-open"></i>
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

    </div>

</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
// فلترة الجدول
function filterTable(){
    let search = $("#search").val().toLowerCase();
    let col    = $("#filter_college").val();
    let study  = $("#filter_study").val();
    let gender = $("#filter_gender").val();

    $("#studentsTable tbody tr").each(function(){
        let row = $(this);
        let txt = row.text().toLowerCase();
        let show = true;

        if (search && !txt.includes(search)) show = false;
        if (col && row.children().eq(2).text() !== col) show = false;
        if (study && row.children().eq(3).text() !== study) show = false;
        if (gender && row.children().eq(4).text() !== gender) show = false;

        row.toggle(show);
    });
}

$("input, select").on("input change", filterTable);

// تصدير CSV حسب البيانات الظاهرة
$("#exportCSV").click(function(){
    let rows = [];
    // رأس الجدول
    let headers = [];
    $("#studentsTable thead th").each(function(){
        headers.push($(this).text().trim());
    });
    rows.push(headers.join(","));

    $("#studentsTable tbody tr:visible").each(function(){
        let cols = [];
        $(this).find("td").each(function(index){
            // تجاهل عمود زر الملف في CSV (آخر عمود)
            if(index === 9) return;
            cols.push($(this).text().trim());
        });
        rows.push(cols.join(","));
    });

    let csv = rows.join("\n");
    let blob = new Blob([csv], {type:"text/csv;charset=utf-8;"});
    let url = URL.createObjectURL(blob);

    let a = document.createElement("a");
    a.href = url;
    a.download = "filtered_students.csv";
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
});
</script>

<?php require_once "includes/footer.php"; ?>