<?php
session_start();
if (!isset($_SESSION['finance_user'])) {
    header("Location: login.php");
    exit;
}

require_once "../config/db.php";
require_once "../config/whatsapp.php";

if (!isset($_POST['student_id'], $_POST['new_level'])) {
    die("❌ Missing data");
}

$student_id = intval($_POST['student_id']);
$new_level  = trim($_POST['new_level']);

/* ===============================================================
   1) جلب بيانات الطالب
=============================================================== */
$st = $conn->prepare("SELECT full_name, phone, college_name FROM students WHERE id=? LIMIT 1");
$st->execute([$student_id]);
$student = $st->fetch(PDO::FETCH_ASSOC);

if (!$student) {
    die("❌ Student not found");
}

/* ===============================================================
   2) جلب القسط الرسمي حسب القسم
=============================================================== */
$c = $conn->prepare("SELECT fee FROM colleges WHERE college_name=? LIMIT 1");
$c->execute([$student['college_name']]);
$fee = intval($c->fetchColumn());

/* ===============================================================
   3) تحديث حساب الطالب للسنة الجديدة
=============================================================== */
$u = $conn->prepare("
    UPDATE accounts SET
        level = ?,
        total_fee = ?,
        paid = 0,
        remaining = ?,
        discount = 0,
        payment_plan = 'دفعة واحدة',
        due_date = NULL,
        last_update = NOW()
    WHERE student_id = ?
");
$u->execute([$new_level, $fee, $fee, $student_id]);

/* ===============================================================
   4) حذف جدول الأقساط القديم للسنة الماضية
=============================================================== */
$del = $conn->prepare("DELETE FROM installment_schedule WHERE account_id IN (SELECT id FROM accounts WHERE student_id=?)");
$del->execute([$student_id]);

/* ===============================================================
   5) إشعار واتساب
=============================================================== */
$message = "
📢 *تم تحديث المرحلة الدراسية*

👤 الطالب: *{$student['full_name']}*
📘 المرحلة الجديدة: *$new_level*

💰 القسط السنوي الجديد: *" . number_format($fee) . " د.ع*

تم فتح حساب جديد لهذه السنة.
";

sendWhatsAppMessage($student["phone"], $message);

/* ===============================================================
   6) إعادة التوجيه
=============================================================== */
header("Location: student_profile.php?id=$student_id&level_updated=1");
exit;
?>